/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.hibernate;

import com.atlassian.confluence.core.BatchOperationManager;
import com.atlassian.confluence.impl.hibernate.HibernateSessionManager5;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SimpleHibernateBatchOperationManager5
implements BatchOperationManager {
    private static final int ARBITRARY_BATCH_SIZE = 50;
    private final HibernateSessionManager5 sessionManager;

    public SimpleHibernateBatchOperationManager5(HibernateSessionManager5 sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public <I, O> Iterable<O> applyInBatches(Iterable<I> input, int batchSize, int expectedTotal, Function<I, O> task) {
        return this.sessionManager.executeThenClearSession(input, batchSize, expectedTotal, task);
    }

    @Override
    public <I, O> Iterable<O> applyInBatches(Iterable<I> input, int expectedTotal, Function<I, O> task) {
        return this.applyInBatches(input, 50, expectedTotal, task);
    }

    @Override
    public <I, O> Iterable<O> applyInChunks(Iterable<I> input, int chunkSize, int sizeToCollect, Function<List<I>, @NonNull List<O>> task) {
        Iterable parts = Iterables.partition(input, (int)chunkSize);
        ArrayList output = new ArrayList(sizeToCollect);
        for (List part : parts) {
            List<O> chunkProcessed = task.apply(part);
            Iterables.addAll(output, (Iterable)chunkProcessed.stream().filter(Objects::nonNull).collect(Collectors.toList()));
            if (output.size() < sizeToCollect) continue;
            break;
        }
        return output;
    }
}

