/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.homepage;

import com.atlassian.confluence.impl.homepage.Homepage;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HomepageService {
    @VisibleForTesting
    static final List<String> REQUIRED_SPACE_PERMISSIONS = ImmutableList.of((Object)"VIEWSPACE", (Object)"USECONFLUENCE");
    private final SpaceManager spaceManager;
    private final GlobalSettingsManager globalSettingsManager;
    private final UserAccessor userAccessor;
    private final SpacePermissionManager spacePermissionManager;

    public HomepageService(SpaceManager spaceManager, GlobalSettingsManager globalSettingsManager, UserAccessor userAccessor, SpacePermissionManager spacePermissionManager) {
        this.spaceManager = Objects.requireNonNull(spaceManager);
        this.globalSettingsManager = Objects.requireNonNull(globalSettingsManager);
        this.userAccessor = Objects.requireNonNull(userAccessor);
        this.spacePermissionManager = Objects.requireNonNull(spacePermissionManager);
    }

    public @NonNull Homepage getHomepage(@Nullable ConfluenceUser user) {
        if (user == null) {
            return this.defaultSiteHome(null);
        }
        return this.userAccessor.getUserPreferences(user).getString("confluence.user.site.homepage").map(StringUtils::trimToNull).map(setting -> this.getHomepage(user, (String)setting)).orElseGet(() -> this.defaultSiteHome(user));
    }

    private Homepage getHomepage(ConfluenceUser user, String userHomepageSetting) {
        switch (userHomepageSetting) {
            case "dashboard": {
                return Homepage.dashboardHomepage();
            }
            case "profile": {
                return Homepage.userProfileHomepage(user);
            }
            case "siteHomepage": {
                return this.defaultSiteHome(user);
            }
        }
        if (Space.isValidPersonalSpaceKey(userHomepageSetting)) {
            return this.getPersonalSpaceHome(user, userHomepageSetting);
        }
        Space space = this.spaceManager.getSpace(userHomepageSetting);
        if (space != null && this.userCanSee(user, space)) {
            return Homepage.spaceHomepage(space);
        }
        return this.defaultSiteHome(user);
    }

    private Homepage getPersonalSpaceHome(ConfluenceUser user, String userHomepageSetting) {
        Space personalSpace = this.spaceManager.getPersonalSpace(user);
        if (personalSpace != null && userHomepageSetting.equals(personalSpace.getKey())) {
            return Homepage.spaceHomepage(personalSpace);
        }
        return this.defaultSiteHome(user);
    }

    private Homepage defaultSiteHome(@Nullable ConfluenceUser user) {
        String siteHomePageSpaceKey = StringUtils.trimToNull((String)this.globalSettingsManager.getGlobalSettings().getSiteHomePage());
        if (siteHomePageSpaceKey != null) {
            Space siteHomeSpace = this.spaceManager.getSpace(siteHomePageSpaceKey);
            if (siteHomeSpace != null && this.userCanSee(user, siteHomeSpace)) {
                return Homepage.spaceHomepage(siteHomeSpace);
            }
            return Homepage.dashboardHomepage();
        }
        return Homepage.dashboardHomepage();
    }

    private boolean userCanSee(@Nullable ConfluenceUser user, Space space) {
        return this.spacePermissionManager.hasAllPermissions(REQUIRED_SPACE_PERMISSIONS, space, user);
    }
}

