/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.i18n;

import com.atlassian.config.ApplicationConfiguration;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.impl.i18n.DefaultI18NBean;
import com.atlassian.confluence.impl.i18n.I18NResourceBundles;
import com.atlassian.confluence.impl.i18n.I18NStateHashExtractor;
import com.atlassian.confluence.impl.i18n.LanguagePluginI18NResource;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.languages.LocaleParser;
import com.atlassian.confluence.languages.TranslationTransform;
import com.atlassian.confluence.plugin.NullPluginAccessor;
import com.atlassian.confluence.plugin.descriptor.TranslationTransformModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.WeightedPluginModuleTracker;
import com.atlassian.confluence.util.i18n.ClasspathI18NResource;
import com.atlassian.confluence.util.i18n.HelpPathsI18NResource;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.util.i18n.I18NResource;
import com.atlassian.confluence.util.i18n.I18nModeManager;
import com.atlassian.confluence.util.i18n.PluginI18NResource;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.BiFunction;
import java.util.stream.Stream;
import org.apache.commons.lang3.LocaleUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class DefaultI18NBeanFactory
implements I18NBeanFactory,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(DefaultI18NBeanFactory.class);
    private static final Supplier<Locale> DEFAULT_LOCALE_SUPPLIER = () -> LocaleManager.DEFAULT_LOCALE;
    public static final String HELP_PATHS_RESOURCE_NAME = "help-paths";
    public static final String HELP_PATHS_RESOURCE_TYPE = "helpPaths";
    public static final String I18N_RESOURCE_TYPE = "i18n";
    private PluginAccessor pluginAccessor;
    private I18nModeManager modeManager;
    private Supplier<Locale> localeSupplier;
    private PluginModuleTracker<TranslationTransform, TranslationTransformModuleDescriptor> pluginModuleTracker;

    public static I18NBeanFactory createMinimal() {
        return new DefaultI18NBeanFactory(new NullPluginAccessor());
    }

    DefaultI18NBeanFactory(PluginAccessor pluginAccessor) {
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
        this.localeSupplier = DEFAULT_LOCALE_SUPPLIER;
    }

    DefaultI18NBeanFactory(PluginAccessor pluginAccessor, ApplicationConfiguration applicationConfig) {
        this.pluginAccessor = Objects.requireNonNull(pluginAccessor);
        Objects.requireNonNull(applicationConfig);
        this.localeSupplier = () -> {
            Locale setupLocale = LocaleParser.toLocale((String)applicationConfig.getProperty((Object)"confluence.setup.locale"));
            if (setupLocale == null) {
                return LocaleManager.DEFAULT_LOCALE;
            }
            return setupLocale;
        };
    }

    static List<ResourceBundle> buildBundles(Locale locale, boolean useCustomLocale, List<I18NResource> resources) {
        ArrayList<ResourceBundle> bundles = new ArrayList<ResourceBundle>();
        if (BootstrapUtils.getBootstrapManager().getHibernateConfig().isHibernateSetup()) {
            List<ResourceBundle> combinedResourceBundles = I18NResourceBundles.getStandardResourceBundles(locale, resources);
            bundles.addAll(combinedResourceBundles);
        } else if (useCustomLocale) {
            List<ResourceBundle> localeSpecificBundles = I18NResourceBundles.getLocaleSpecificResourceBundles(locale, resources);
            if (localeSpecificBundles != null) {
                bundles.addAll(localeSpecificBundles);
            }
            bundles.add(I18NResourceBundles.getCoreBundle());
        } else {
            ResourceBundle bundle = I18NResourceBundles.getDefaultResourceBundle();
            if (bundle != null) {
                bundles.add(bundle);
            }
        }
        return bundles;
    }

    static List<I18NResource> getI18NResources(PluginAccessor pluginAccessor, boolean useCustomLocale) {
        List<Object> resources = BootstrapUtils.getBootstrapManager().getHibernateConfig().isHibernateSetup() || useCustomLocale ? DefaultI18NBeanFactory.loadI18NResources(pluginAccessor) : Collections.emptyList();
        return resources;
    }

    private static List<I18NResource> loadI18NResources(PluginAccessor pluginAccessor) {
        ImmutableList.Builder resources = ImmutableList.builder();
        resources.add((Object)new LanguagePluginI18NResource(pluginAccessor));
        resources.addAll(DefaultI18NBeanFactory.loadPluginResources(pluginAccessor, I18N_RESOURCE_TYPE, PluginI18NResource::new));
        resources.addAll(DefaultI18NBeanFactory.loadPluginResources(pluginAccessor, HELP_PATHS_RESOURCE_TYPE, HelpPathsI18NResource::new));
        resources.add((Object)new ClasspathI18NResource(HELP_PATHS_RESOURCE_NAME));
        return resources.build();
    }

    private static List<I18NResource> loadPluginResources(PluginAccessor pluginAccessor, String resourceType, BiFunction<Plugin, ResourceDescriptor, I18NResource> resourceFactory) {
        ArrayList<I18NResource> resources = new ArrayList<I18NResource>();
        for (Plugin plugin : pluginAccessor.getEnabledPlugins()) {
            try {
                DefaultI18NBeanFactory.findResourceDescriptors(plugin, resourceType).map(resourceDescriptor -> (I18NResource)resourceFactory.apply(plugin, (ResourceDescriptor)resourceDescriptor)).forEach(resources::add);
            }
            catch (RuntimeException e) {
                log.error("Unable to load [{}] resources for plugin [{}]", new Object[]{resourceType, plugin.getKey(), e});
            }
        }
        return resources;
    }

    private static Stream<ResourceDescriptor> findResourceDescriptors(Plugin plugin, String resourceType) {
        return Stream.concat(Stream.of(plugin), plugin.getModuleDescriptors().stream()).flatMap(resourced -> resourced.getResourceDescriptors().stream()).filter(resourceDescriptor -> resourceType.equals(resourceDescriptor.getType()));
    }

    public static I18NBean getDefaultI18NBean() {
        ResourceBundle defaultResourceBundle = I18NResourceBundles.getDefaultResourceBundle();
        List<ResourceBundle> resourceBundles = defaultResourceBundle != null ? List.of(defaultResourceBundle) : Collections.emptyList();
        return new DefaultI18NBean((Locale)DEFAULT_LOCALE_SUPPLIER.get(), null, null, resourceBundles);
    }

    public @NonNull I18NBean getI18NBean(@NonNull Locale locale) {
        if (LocaleUtils.isAvailableLocale((Locale)locale)) {
            boolean useCustomLocale = !locale.equals(LocaleManager.DEFAULT_LOCALE);
            List<I18NResource> resources = DefaultI18NBeanFactory.getI18NResources(this.pluginAccessor, useCustomLocale);
            return new DefaultI18NBean(locale, this.pluginModuleTracker, this.modeManager, DefaultI18NBeanFactory.buildBundles(locale, useCustomLocale, resources));
        }
        return this.getI18NBean();
    }

    public @NonNull I18NBean getI18NBean() {
        return this.getI18NBean((Locale)this.localeSupplier.get());
    }

    public @NonNull String getStateHash() {
        return new I18NStateHashExtractor(this.pluginAccessor, this.pluginModuleTracker).calculateStateHash();
    }

    public void setModeManager(I18nModeManager modeManager) {
        this.modeManager = modeManager;
    }

    public void setPluginEventManager(PluginEventManager pluginEventManager) {
        this.pluginModuleTracker = WeightedPluginModuleTracker.create(this.pluginAccessor, pluginEventManager, TranslationTransformModuleDescriptor.class);
    }

    public void destroy() throws Exception {
        if (this.pluginModuleTracker != null) {
            this.pluginModuleTracker.close();
        }
    }
}

