/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.i18n;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.impl.i18n.DefaultI18NBean;
import com.atlassian.confluence.util.i18n.CombinedResourceBundleFactory;
import com.atlassian.confluence.util.i18n.I18NResource;
import com.atlassian.confluence.util.i18n.I18NResourceBundlesLoader;
import com.atlassian.confluence.util.i18n.ResourceBundlesCollector;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

final class I18NResourceBundles {
    private static final Logger log = LoggerFactory.getLogger(I18NResourceBundles.class);

    I18NResourceBundles() {
    }

    static ResourceBundle getDefaultResourceBundle() {
        ResourceBundle helpPathsBundle;
        ResourceBundle coreBundle = I18NResourceBundles.getCoreBundle();
        if (coreBundle == null) {
            return null;
        }
        ResourceBundle externalLinksBundle = I18NResourceBundles.getExternalLinksBundle();
        ArrayList<ResourceBundle> defaultBundles = new ArrayList<ResourceBundle>();
        defaultBundles.add(coreBundle);
        if (externalLinksBundle != null) {
            defaultBundles.add(externalLinksBundle);
        }
        if ((helpPathsBundle = I18NResourceBundles.getDefaultHelpPathsBundle()) != null) {
            defaultBundles.add(helpPathsBundle);
        }
        return CombinedResourceBundleFactory.createCombinedResourceBundle(defaultBundles);
    }

    static ResourceBundle getCoreBundle() {
        String path = ConfluenceActionSupport.class.getName().replace('.', '/') + ".properties";
        return I18NResourceBundles.getResourceBundle(path);
    }

    static ResourceBundle getExternalLinksBundle() {
        return I18NResourceBundles.getResourceBundle("external-links.properties");
    }

    private static ResourceBundle getDefaultHelpPathsBundle() {
        return I18NResourceBundles.getResourceBundle("i18n/help-paths.properties");
    }

    private static ResourceBundle getResourceBundle(String path) {
        PropertyResourceBundle propertyResourceBundle;
        block8: {
            ClassPathResource resource = new ClassPathResource(path, DefaultI18NBean.class.getClassLoader());
            InputStream resourceAsStream = resource.getInputStream();
            try {
                propertyResourceBundle = new PropertyResourceBundle(resourceAsStream);
                if (resourceAsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException e) {
                    log.error("Error occurred reading the stream for {}", (Object)resource, (Object)e);
                    return null;
                }
            }
            resourceAsStream.close();
        }
        return propertyResourceBundle;
    }

    private static void loadDefaultBundle(ResourceBundlesCollector bundlesCollector) {
        bundlesCollector.addBundle(I18NResourceBundles.getDefaultResourceBundle());
    }

    static List<ResourceBundle> getStandardResourceBundles(Locale locale, List<I18NResource> resources) {
        ResourceBundlesCollector bundlesCollector = new ResourceBundlesCollector();
        I18NResourceBundles.loadDefaultBundle(bundlesCollector);
        I18NResourceBundles.loadResourceBundles(bundlesCollector, locale, resources);
        return bundlesCollector.getCombinedResourceBundles();
    }

    static void loadResourceBundles(ResourceBundlesCollector bundlesCollector, Locale locale, List<I18NResource> resources) {
        resources.stream().map(resource -> I18NResourceBundlesLoader.getResourceBundles((I18NResource)resource, (Locale)locale)).forEach(arg_0 -> ((ResourceBundlesCollector)bundlesCollector).addBundles(arg_0));
    }

    static List<ResourceBundle> getLocaleSpecificResourceBundles(Locale locale, List<I18NResource> resources) {
        ResourceBundlesCollector bundlesCollector = new ResourceBundlesCollector();
        ResourceBundle externalLinksBundle = I18NResourceBundles.getExternalLinksBundle();
        if (externalLinksBundle != null) {
            bundlesCollector.addBundle(externalLinksBundle);
        }
        I18NResourceBundles.loadResourceBundles(bundlesCollector, locale, resources);
        return bundlesCollector.getCombinedResourceBundles();
    }
}

