/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.i18n;

import com.atlassian.confluence.languages.TranslationTransform;
import com.atlassian.confluence.plugin.descriptor.LanguageModuleDescriptor;
import com.atlassian.confluence.plugin.descriptor.TranslationTransformModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.Resourced;
import com.atlassian.plugin.ScopeAware;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;

final class I18NStateHashExtractor {
    private final PluginAccessor pluginAccessor;
    private final PluginModuleTracker<TranslationTransform, TranslationTransformModuleDescriptor> pluginModuleTracker;

    I18NStateHashExtractor(PluginAccessor pluginAccessor, @Nullable PluginModuleTracker<TranslationTransform, TranslationTransformModuleDescriptor> pluginModuleTracker) {
        this.pluginAccessor = pluginAccessor;
        this.pluginModuleTracker = pluginModuleTracker;
    }

    String calculateStateHash() {
        I18NStateHashExtractor calculator = new I18NStateHashExtractor(this.pluginAccessor, this.pluginModuleTracker);
        return Integer.toString(calculator.getPluginHashKeys().hashCode() + calculator.getTransformerHashKeys().hashCode(), 36);
    }

    Collection<String> getTransformerHashKeys() {
        return this.pluginModuleTracker == null ? Collections.emptyList() : Streams.stream((Iterable)this.pluginModuleTracker.getModules()).map(transform -> transform.getClass().getName() + transform.getStateHash()).toList();
    }

    Collection<String> getPluginHashKeys() {
        return this.pluginAccessor.getEnabledPlugins().stream().filter(this::affectsI18n).flatMap(this::getHashKeys).toList();
    }

    private Stream<String> getHashKeys(Plugin plugin) {
        return Stream.of(plugin.getKey(), plugin.getPluginInformation().getVersion());
    }

    private boolean affectsI18n(Plugin plugin) {
        return Stream.concat(Stream.of(plugin), plugin.getModuleDescriptors().stream()).anyMatch(x$0 -> this.affectsI18n((ScopeAware)x$0));
    }

    private <T extends ScopeAware & Resourced> boolean affectsI18n(T descriptor) {
        return descriptor instanceof LanguageModuleDescriptor || descriptor instanceof TranslationTransformModuleDescriptor || ((Resourced)descriptor).getResourceDescriptors().stream().anyMatch(this::affectsI18n);
    }

    private boolean affectsI18n(ResourceDescriptor resource) {
        String type = resource.getType();
        return type != null && Set.of("helpPaths", "i18n").contains(type);
    }
}

