/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.i18n.sal;

import com.atlassian.confluence.languages.Language;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserResolver;
import com.atlassian.sal.api.message.LocaleResolver;
import com.atlassian.sal.api.user.UserKey;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ConfluenceLocaleResolver
implements LocaleResolver {
    private final ConfluenceUserResolver userResolver;
    private final LanguageManager languageManager;
    private final LocaleManager localeManager;

    public ConfluenceLocaleResolver(LocaleManager localeManager, ConfluenceUserResolver userResolver, LanguageManager languageManager) {
        this.localeManager = localeManager;
        this.userResolver = userResolver;
        this.languageManager = languageManager;
    }

    public ConfluenceLocaleResolver(LanguageManager languageManager, LocaleManager localeManager) {
        this.languageManager = languageManager;
        this.localeManager = localeManager;
        this.userResolver = null;
    }

    public Locale getLocale(HttpServletRequest request) {
        if (this.userResolver != null) {
            return this.localeManager.getLocale(this.userResolver.getUserByName(request.getRemoteUser()));
        }
        return this.getLocale();
    }

    public Locale getLocale() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.localeManager.getLocale(user);
    }

    public Locale getLocale(UserKey userKey) {
        ConfluenceUser user = null;
        if (this.userResolver != null) {
            user = this.userResolver.getExistingUserByKey(userKey);
        }
        return this.localeManager.getLocale(user);
    }

    public Locale getApplicationLocale() {
        return this.localeManager.getSiteDefaultLocale();
    }

    public Set<Locale> getSupportedLocales() {
        List<Language> langs = this.languageManager.getLanguages();
        HashSet<Locale> ret = new HashSet<Locale>();
        for (Language lang : langs) {
            ret.add(lang.getLocale());
        }
        return Collections.unmodifiableSet(ret);
    }
}

