/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.importexport;

import com.atlassian.confluence.api.model.backuprestore.JobOperation;
import com.atlassian.confluence.api.model.backuprestore.JobScope;
import com.atlassian.confluence.api.model.backuprestore.JobState;
import com.atlassian.confluence.backuprestore.BackupRestoreJob;
import com.atlassian.confluence.backuprestore.BackupRestoreManager;
import com.atlassian.confluence.backuprestore.BackupRestoreSettings;
import com.atlassian.confluence.backuprestore.exception.NotPermittedException;
import com.atlassian.confluence.backuprestore.exception.TheSameSpaceBackupRestoreJobAlreadyInProgressException;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.dmz.pages.AttachmentManagerInternal;
import com.atlassian.confluence.impl.backuprestore.BackupRestoreFilesystemManager;
import com.atlassian.confluence.impl.backuprestore.IndependentBackupRestoreJobManager;
import com.atlassian.confluence.impl.importexport.AbstractXmlExporter;
import com.atlassian.confluence.importexport.ExportScope;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.plugin.BackupRestoreException;
import com.atlassian.confluence.importexport.plugin.BackupRestoreProvider;
import com.atlassian.confluence.importexport.plugin.BackupRestoreProviderManager;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDao;
import com.atlassian.confluence.pages.persistence.dao.AttachmentDaoFactory;
import com.atlassian.confluence.pages.persistence.dao.FileSystemAttachmentDataDao;
import com.atlassian.confluence.pages.persistence.dao.SimpleFileLocationResolver;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.core.util.FileUtils;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.dc.filestore.api.compat.FilesystemPath;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.spring.container.ContainerManager;
import io.atlassian.util.concurrent.ThreadFactories;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFileXmlExporter
extends AbstractXmlExporter {
    private static final Logger log = LoggerFactory.getLogger(AbstractFileXmlExporter.class);
    protected AttachmentManagerInternal attachmentManager;
    private FilesystemPath confluenceHome;
    protected final ExecutorService executorService = Executors.newCachedThreadPool(ThreadFactories.namedThreadFactory((String)"legacy-xml-export"));
    private BackupRestoreProviderManager backupRestoreProviderManager;
    private final AtomicInteger backupInteger = new AtomicInteger();

    @Override
    public String doExport(ProgressMeter progress) throws ImportExportException {
        log.error("AbstractFileXmlExporter.doExport is going to be removed in future releases!");
        JobScope jobScope = this.getJobScope(this.getWorkingExportContext().getExportScope());
        File tempDirectory = GeneralUtil.createTempDirectoryInConfluenceTemp("legacy-export");
        BackupRestoreSettings.Builder builder = new BackupRestoreSettings.Builder(JobOperation.BACKUP, jobScope).skipAttachments(false).setFilename("backup-file-" + this.backupInteger.incrementAndGet() + ".zip").setWorkingDir(tempDirectory.toString());
        if (jobScope.equals((Object)JobScope.SPACE)) {
            builder = builder.addSpaceKey(this.context.getSpaceKeyOfSpaceExport());
        }
        BackupRestoreSettings backupRestoreSettings = builder.build();
        BackupRestoreManager backupRestoreManager = (BackupRestoreManager)ContainerManager.getComponent((String)"backupRestoreManager");
        try {
            BackupRestoreJob backupRestoreJob;
            switch (this.getWorkingExportContext().getExportScope()) {
                case ALL: 
                case SITE: {
                    BackupRestoreJob backupRestoreJob2;
                    backupRestoreJob = backupRestoreJob2 = backupRestoreManager.startSiteBackup(backupRestoreSettings);
                    break;
                }
                case SPACE: {
                    BackupRestoreJob backupRestoreJob2;
                    try {
                        backupRestoreJob = backupRestoreJob2 = backupRestoreManager.startSpaceBackup(backupRestoreSettings);
                        break;
                    }
                    catch (TheSameSpaceBackupRestoreJobAlreadyInProgressException e) {
                        throw new ImportExportException(e);
                    }
                }
                default: {
                    throw new IllegalArgumentException("Export scope " + String.valueOf((Object)this.getWorkingExportContext().getExportScope()) + " is not supported");
                }
            }
            BackupRestoreJob job = backupRestoreJob;
            this.waitUntilJobFinishes(job.getId());
            File fullFileName = this.getFullFileName(job.getFileName(), job.getJobScope());
            String fileInTempFolder = this.bootstrapManager.getFilePathProperty("struts.multipart.saveDir") + File.separator + job.getFileName() + ".zip";
            FileUtils.copyFile((File)fullFileName, (File)new File(fileInTempFolder));
            return fileInTempFolder;
        }
        catch (NotPermittedException | IOException e) {
            throw new ImportExportException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Restore process was interrupted");
        }
    }

    private File getFullFileName(String fileName, JobScope jobScope) throws IOException {
        BackupRestoreFilesystemManager backupRestoreFilesystemManager = (BackupRestoreFilesystemManager)ContainerManager.getComponent((String)"backupRestoreFilesystemManager");
        return backupRestoreFilesystemManager.getFile(fileName, jobScope);
    }

    protected void waitUntilJobFinishes(Long jobId) throws InterruptedException {
        IndependentBackupRestoreJobManager independentBackupRestoreJobManager = (IndependentBackupRestoreJobManager)ContainerManager.getComponent((String)"independentBackupRestoreJobManager");
        long TIMEOUT = 30000L;
        long STATE_CHECKING_INTERVAL_MS = 5000L;
        long deadline = System.currentTimeMillis() + 30000L;
        while (System.currentTimeMillis() < deadline) {
            Thread.sleep(5000L);
            JobState jobState = independentBackupRestoreJobManager.getJobState(this.executorService, jobId).orElseThrow(() -> new BackupRestoreException("Job with id " + jobId + " was not found"));
            if (!jobState.isFinished()) continue;
            return;
        }
        throw new IllegalStateException("The job with id " + jobId + " has not finished. It's state: " + jobId);
    }

    private JobScope getJobScope(ExportScope exportScope) {
        switch (exportScope) {
            case ALL: 
            case SITE: {
                return JobScope.SITE;
            }
            case SPACE: {
                return JobScope.SPACE;
            }
        }
        throw new IllegalArgumentException("Export scope " + String.valueOf((Object)exportScope) + " is not supported");
    }

    protected abstract List<Space> getIncludedSpaces();

    protected void backupAttachments() throws ImportExportException {
        AttachmentDaoFactory attachmentDaoFactory = (AttachmentDaoFactory)ContainerManager.getComponent((String)"attachmentDaoFactory");
        File attachmentDir = new File(this.getWorkingExportContext().getExportDirectory(), "attachments");
        this.ensureDirectoryCreated(attachmentDir);
        SimpleFileLocationResolver locationResolver = new SimpleFileLocationResolver(attachmentDir);
        FileSystemAttachmentDataDao exportDataDao = new FileSystemAttachmentDataDao();
        exportDataDao.setAttachmentsDirResolver(locationResolver);
        AttachmentDao exportDao = attachmentDaoFactory.getInstance(exportDataDao);
        AttachmentDao sourceDao = this.attachmentManager.getAttachmentDao();
        AttachmentDao.AttachmentCopier copier = sourceDao.getCopier(exportDao);
        copier.setParentContentToExclude(this.getObjectsExcludedFromExport());
        copier.setSpacesToInclude(this.getIncludedSpaces());
        copier.copy();
    }

    protected void backupResources() throws ImportExportException {
        File resourceDir = new File(this.getWorkingExportContext().getExportDirectory(), "resources");
        this.ensureDirectoryCreated(resourceDir);
        try {
            if (this.getExportScope() == ExportScope.ALL) {
                File baseResourceDir = new File(this.getConfluenceHome(), "resources");
                FileUtils.copyDirectory((File)baseResourceDir, (File)resourceDir);
            } else if (this.getExportScope() == ExportScope.SPACE) {
                List<File> baseResourceDirs = this.getEntityResourceDirectories();
                this.copyDirectories(baseResourceDirs, resourceDir);
            }
        }
        catch (IOException e) {
            log.error("Couldn't backup attachments.", (Throwable)e);
            throw new ImportExportException("Couldn't backup attachments.", e);
        }
    }

    private File getConfluenceHome() {
        if (this.confluenceHome != null) {
            return this.confluenceHome.asJavaFile();
        }
        return new File(this.bootstrapManager.getConfluenceHome());
    }

    protected void backupTemplates() throws ImportExportException {
        File templatesDir = this.getWorkingExportContext().getExportDirectory();
        this.ensureDirectoryCreated(templatesDir);
        try {
            List templateDirs = this.getSourceTemplateDirForCopying();
            this.copyDirectories(templateDirs, templatesDir);
        }
        catch (IOException e) {
            log.error("Couldn't backup template directory", (Throwable)e);
            throw new ImportExportException("Couldn't backup templates directory");
        }
    }

    protected void backupConfigFiles() throws ImportExportException {
        File configDirectory = this.getWorkingExportContext().getExportDirectory();
        File currentConfigDirectory = new File(this.bootstrapManager.getLocalHome(), "config");
        if (currentConfigDirectory.exists()) {
            ArrayList<File> currentConfigDirAsList = new ArrayList<File>();
            currentConfigDirAsList.add(currentConfigDirectory);
            try {
                this.copyDirectories(currentConfigDirAsList, configDirectory);
            }
            catch (IOException e) {
                log.error("Error copying config directory over to backup. Directory: {}", (Object)currentConfigDirectory, (Object)e);
            }
        }
    }

    protected void backupPluginData() throws ImportExportException {
        File baseExportDir = this.getWorkingExportContext().getExportDirectory();
        for (ModuleDescriptor moduleDescriptor : this.backupRestoreProviderManager.getModuleDescriptors()) {
            try {
                File pluginDataFile = this.backupRestoreProviderManager.createModuleBackupFile(baseExportDir, (ModuleDescriptor<BackupRestoreProvider>)moduleDescriptor);
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(pluginDataFile));){
                    ((BackupRestoreProvider)moduleDescriptor.getModule()).backup(os);
                }
            }
            catch (IOException io) {
                throw new ImportExportException("IOException whilst exporting plugin data for : " + moduleDescriptor.getCompleteKey(), io);
            }
        }
    }

    private void copyDirectories(List sourceDirs, File targetDir) throws IOException {
        for (int i = 0; i < sourceDirs.size(); ++i) {
            File sourceDir = (File)sourceDirs.get(i);
            File destDir = new File(targetDir, sourceDir.getName());
            if (!sourceDir.isDirectory()) continue;
            FileUtils.copyDirectory((File)sourceDir, (File)destDir);
        }
    }

    private List<File> getEntityResourceDirectories() {
        File resourcePath = new File(this.getConfluenceHome(), "resources");
        ArrayList<File> entityResourceDirs = new ArrayList<File>();
        for (ConfluenceEntityObject o : this.context.getWorkingEntities()) {
            File spaceResourceDir;
            if (!(o instanceof Space) || !(spaceResourceDir = new File(resourcePath, ((Space)o).getKey())).exists()) continue;
            entityResourceDirs.add(spaceResourceDir);
        }
        return entityResourceDirs;
    }

    public void setAttachmentManager(AttachmentManagerInternal attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setBackupRestoreProviderManager(BackupRestoreProviderManager backupRestoreProviderManager) {
        this.backupRestoreProviderManager = backupRestoreProviderManager;
    }

    public void setConfluenceHome(FilesystemPath confluenceHome) {
        this.confluenceHome = confluenceHome;
    }
}

