/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.importexport;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.impl.importexport.AbstractExporterImpl;
import com.atlassian.confluence.importexport.ExportScope;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.upgrade.UpgradeManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXmlExporter
extends AbstractExporterImpl {
    private static final Logger log = LoggerFactory.getLogger(AbstractXmlExporter.class);
    public static final String EXPORT_DESCRIPTOR_FILE_NAME = "exportDescriptor.properties";
    public static final String ENTITIES_FILE_NAME = "entities.xml";
    public static final String ATTACHMENTS_DIRECTORY = "attachments";
    public static final String TEMPLATES_DIRECTORY = "velocity";
    protected SessionFactory sessionFactory5;
    private SettingsManager settingsManager;
    protected BootstrapManager bootstrapManager;
    protected SpaceManager spaceManager;
    private UpgradeManager upgradeManager;

    public void setSessionFactory5(SessionFactory sessionFactory) {
        this.sessionFactory5 = sessionFactory;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    protected List<ConfluenceEntityObject> getObjectsExcludedFromExport() throws ImportExportException {
        if (this.getWorkingExportContext() != null && this.getWorkingExportContext().getExceptionEntities() != null) {
            return this.getWorkingExportContext().getExceptionEntities();
        }
        return new ArrayList<ConfluenceEntityObject>();
    }

    protected OutputStream getXmlOutputStream() throws IOException {
        File destFile = new File(this.getWorkingExportContext().getExportDirectory(), ENTITIES_FILE_NAME);
        destFile.getParentFile().mkdirs();
        destFile.createNewFile();
        return new FileOutputStream(destFile);
    }

    protected ExportScope getExportScope() {
        if (this.getWorkingExportContext() == null) {
            return ExportScope.ALL;
        }
        return this.getWorkingExportContext().getExportScope();
    }

    protected abstract List getSourceTemplateDirForCopying();

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setUpgradeManager(UpgradeManager upgradeManager) {
        this.upgradeManager = upgradeManager;
    }

    protected SettingsManager getSettingsManager() {
        return this.settingsManager;
    }
}

