/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.importexport;

import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.persistence.hibernate.CacheMode;
import com.atlassian.confluence.core.persistence.hibernate.SessionCacheModeThreadLocal;
import com.atlassian.confluence.dmz.importexport.LegacyImportExportManager;
import com.atlassian.confluence.event.events.admin.AsyncExportFinishedEvent;
import com.atlassian.confluence.event.events.admin.ExportFinishedEvent;
import com.atlassian.confluence.impl.importexport.BackupImporter;
import com.atlassian.confluence.impl.importexport.DefaultImmutableImportProcessorSummary;
import com.atlassian.confluence.importexport.ExportContext;
import com.atlassian.confluence.importexport.Exporter;
import com.atlassian.confluence.importexport.ImmutableImportProcessorSummary;
import com.atlassian.confluence.importexport.ImportContext;
import com.atlassian.confluence.importexport.ImportExportException;
import com.atlassian.confluence.importexport.ImportProcessorSummary;
import com.atlassian.confluence.importexport.PostImportTask;
import com.atlassian.confluence.pages.ContentTree;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.pages.TreeBuilder;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.confluence.util.Cleanup;
import com.atlassian.confluence.util.OutputTypeThreadLocal;
import com.atlassian.core.util.ProgressMeter;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class DefaultImportExportManager
implements LegacyImportExportManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultImportExportManager.class);
    public static final String EXPORT_ALL_FILE_PREFIX = "export-";
    private final ContentPermissionManager contentPermissionManager;
    private final BootstrapManager bootstrapManager;
    private final PageManager pageManager;
    private final EventPublisher eventPublisher;

    public DefaultImportExportManager(ContentPermissionManager contentPermissionManager, BootstrapManager bootstrapManager, PageManager pageManager, EventPublisher eventPublisher) {
        this.contentPermissionManager = contentPermissionManager;
        this.bootstrapManager = bootstrapManager;
        this.pageManager = pageManager;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public ImmutableImportProcessorSummary performImport(ImportContext context) throws ImportExportException {
        try (Cleanup cleanup = SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.IGNORE);){
            ImmutableImportProcessorSummary immutableImportProcessorSummary = this.doPerformImport(context);
            return immutableImportProcessorSummary;
        }
    }

    protected ImmutableImportProcessorSummary doPerformImport(ImportContext context) throws ImportExportException {
        ImportProcessorSummary importProcessorSummary = this.performImportInternal(context);
        return DefaultImmutableImportProcessorSummary.newInstance(importProcessorSummary);
    }

    private ImportProcessorSummary performImportInternal(ImportContext context) throws ImportExportException {
        Cleanup interferingPluginsTask = this.temporarilyShutdownInterferingPlugins(context);
        BackupImporter backupImporter = (BackupImporter)ContainerManager.getComponent((String)"backupImporter", BackupImporter.class);
        backupImporter.setContext(this.addPostImportTasks(context, context1 -> interferingPluginsTask.close()));
        return backupImporter.doImport();
    }

    private ImportContext addPostImportTasks(ImportContext context, PostImportTask ... tasks) {
        context.setPostImportTasks(Lists.newArrayList((Iterable)Iterables.concat(context.getPostImportTasks(), Arrays.asList(tasks))));
        return context;
    }

    @VisibleForTesting
    protected final Cleanup temporarilyShutdownInterferingPlugins(ImportContext ignored) {
        return () -> {};
    }

    @Override
    public String exportAs(ExportContext context, ProgressMeter progress) throws ImportExportException {
        String string;
        block8: {
            Cleanup cleanup = SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.IGNORE);
            try {
                OutputTypeThreadLocal.set(ConversionContextOutputType.fromLegacyImportExportValue(context.getType()));
                String result = this.doExport(context, progress);
                OutputTypeThreadLocal.clear();
                string = result;
                if (cleanup == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (cleanup != null) {
                        try {
                            cleanup.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    log.warn("Error exporting content", (Throwable)e);
                    OutputTypeThreadLocal.clear();
                    throw e;
                }
            }
            cleanup.close();
        }
        return string;
    }

    protected String doExport(ExportContext context, ProgressMeter progress) throws ImportExportException {
        String type = context.getType();
        if (type == null || !type.equals("TYPE_HTML") && !type.equals("TYPE_XML") && !type.equals("TYPE_ALL_DATA")) {
            throw new IllegalArgumentException("Type must be TYPE_HTML, TYPE_XML or TYPE_ALL_DATA!");
        }
        if (!"TYPE_HTML".equals(type)) {
            throw new IllegalStateException("DefaultImportExportManager.doExport does not support xml export anymore.");
        }
        Exporter exporter = (Exporter)ContainerManager.getComponent((String)"htmlExporter", Exporter.class);
        if (exporter == null) {
            throw new ImportExportException("Exporter missing for type: " + type);
        }
        exporter.setContext(context);
        OutputTypeThreadLocal.set(ConversionContextOutputType.fromLegacyImportExportValue(context.getType()));
        String pathToExport = exporter.doExport(progress);
        OutputTypeThreadLocal.clear();
        this.eventPublisher.publish((Object)new ExportFinishedEvent(this, context.getType(), context.getExportScope().getString(), context.getSpaceKeyOfSpaceExport()));
        this.eventPublisher.publish((Object)new AsyncExportFinishedEvent(this, context.getType(), context.getExportScope().getString(), context.getSpaceKeyOfSpaceExport()));
        return pathToExport;
    }

    @Override
    public ContentTree getContentTree(User user, Space space) {
        TreeBuilder treeBuilder = new TreeBuilder(FindUserHelper.getUser(user), this.contentPermissionManager, this.pageManager);
        return treeBuilder.createPageTree(space);
    }

    @Override
    public ContentTree getPageBlogTree(User user, Space space) {
        TreeBuilder treeBuilder = new TreeBuilder(FindUserHelper.getUser(user), this.contentPermissionManager, this.pageManager);
        return treeBuilder.createPageBlogTree(space);
    }

    @Override
    public String prepareDownloadPath(String path) throws IOException {
        String exportDir = this.bootstrapManager.getFilePathProperty("struts.multipart.saveDir");
        String canonicalPath = new File(path).getCanonicalPath();
        int exportDirIndex = canonicalPath.indexOf(exportDir);
        Object result = path;
        if (exportDirIndex != -1) {
            result = canonicalPath.substring(exportDirIndex + exportDir.length());
        } else {
            log.error("Path is not in export temp directory.");
        }
        result = "/download/export" + (String)result;
        result = ((String)result).replaceAll("\\".equals(File.separator) ? "\\\\" : File.separator, "/");
        return result;
    }
}

