/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.incrementalsync;

import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.confluence.cache.CoreCache;
import com.atlassian.confluence.impl.cache.ReadThroughAtlassianCache;
import com.atlassian.confluence.impl.cache.ReadThroughCache;
import com.atlassian.confluence.incrementalsync.SpaceFilteringManager;
import java.util.Set;

public class CachedSpaceFilteringManager
implements SpaceFilteringManager {
    private static final int CACHE_MAX_SIZE = Integer.getInteger("atlassian.confluence.synchronisation.spaces.exclusion.cache.size", 6000);
    private final SpaceFilteringManager delegate;
    private final ReadThroughCache<String, Boolean> isExcludedCache;

    public CachedSpaceFilteringManager(SpaceFilteringManager delegate, CacheFactory cacheFactory) {
        this.delegate = delegate;
        this.isExcludedCache = CoreCache.SPACE_EXCLUSIONS.resolve(cacheName -> {
            CacheSettings cacheSettings = new CacheSettingsBuilder().remote().replicateViaInvalidation().replicateAsynchronously().maxEntries(CACHE_MAX_SIZE).flushable().build();
            return new ReadThroughAtlassianCache(cacheFactory.getCache(cacheName, null, cacheSettings));
        });
    }

    @Override
    public void replaceList(Set<String> spaceKeys, boolean optInNewSpaces, String source) {
        this.isExcludedCache.removeAll();
        this.delegate.replaceList(spaceKeys, optInNewSpaces, source);
    }

    @Override
    public boolean isExcluded(String spaceKey) {
        return this.isExcludedCache.get(spaceKey, () -> this.delegate.isExcluded(spaceKey));
    }

    @Override
    public void resetList(String source) {
        this.isExcludedCache.removeAll();
        this.delegate.resetList(source);
    }

    @Override
    public boolean optInNewSpaces() {
        return this.delegate.optInNewSpaces();
    }

    @Override
    public Set<String> getAllowedSpaces() {
        return this.delegate.getAllowedSpaces();
    }

    @Override
    public boolean isOptedIn() {
        return this.delegate.isOptedIn();
    }

    @Override
    public void addSpace(String key, String source) {
        this.isExcludedCache.removeAll();
        this.delegate.addSpace(key, source);
    }
}

