/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.incrementalsync;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.cache.CoreCache;
import com.atlassian.confluence.impl.cache.ReadThroughAtlassianCache;
import com.atlassian.confluence.impl.cache.ReadThroughCache;
import com.atlassian.confluence.incrementalsync.IncrementalSyncSubscriptionManager;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncState;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncSubscription;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import java.time.Instant;
import java.util.Collection;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingIncrementalSyncSubscriptionManager
implements IncrementalSyncSubscriptionManager {
    private static final Logger log = LoggerFactory.getLogger(CachingIncrementalSyncSubscriptionManager.class);
    private final IncrementalSyncSubscriptionManager delegate;
    private final ReadThroughCache<String, Optional<IncrementalSyncSubscription>> cache;

    CachingIncrementalSyncSubscriptionManager(IncrementalSyncSubscriptionManager delegate, ReadThroughCache<String, Optional<IncrementalSyncSubscription>> cache) {
        this.delegate = delegate;
        this.cache = cache;
    }

    @VisibleForTesting
    public static IncrementalSyncSubscriptionManager create(IncrementalSyncSubscriptionManager delegate, CacheFactory cacheFactory) {
        return new CachingIncrementalSyncSubscriptionManager(delegate, ReadThroughAtlassianCache.create(cacheFactory, CoreCache.INCREMENTAL_SUBSCRIPTION));
    }

    @Override
    public SubscriptionId store(IncrementalSyncSubscription subscription) {
        long subscriptionId = subscription.getId();
        SubscriptionId updatedSubscriptionId = this.delegate.store(subscription);
        log.debug("Subscription {} is updated. Also updating the cache", (Object)subscriptionId);
        this.cache.remove(CachingIncrementalSyncSubscriptionManager.getCacheKey(subscriptionId));
        this.cache.get(CachingIncrementalSyncSubscriptionManager.getCacheKey(subscriptionId), () -> Optional.of(subscription));
        return updatedSubscriptionId;
    }

    @Override
    public Optional<IncrementalSyncSubscription> getSubscription(long id) {
        return this.cache.get(CachingIncrementalSyncSubscriptionManager.getCacheKey(id), () -> {
            log.debug("Retrieving subscription with id {} from datastore for caching", (Object)id);
            return this.delegate.getSubscription(id);
        });
    }

    @Override
    public Collection<IncrementalSyncSubscription> getSubscriptionsByContext(String context) {
        return this.delegate.getSubscriptionsByContext(context);
    }

    @Override
    public Collection<IncrementalSyncSubscription> getSubscriptionsByContext(String context, IncrementalSyncState state) {
        return this.delegate.getSubscriptionsByContext(context, state);
    }

    @Override
    public boolean removeSubscription(long id) {
        this.cache.remove(CachingIncrementalSyncSubscriptionManager.getCacheKey(id));
        return this.delegate.removeSubscription(id);
    }

    @Override
    public int removeAllSubscriptions(String contextKey) {
        int result = this.delegate.removeAllSubscriptions(contextKey);
        if (result > 0) {
            log.debug("Clean cache because the datastore has changed for removeAllSubscriptions");
            this.cache.removeAll();
        }
        return result;
    }

    @Override
    public int removeExpiredSubscriptions(String contextKey, Instant ttl) {
        int result = this.delegate.removeExpiredSubscriptions(contextKey, ttl);
        if (result > 0) {
            log.debug("Clean cache because the datastore has changed for removeExpiredSubscriptions");
            this.cache.removeAll();
        }
        return result;
    }

    @Override
    public int removeDeletedSubscriptions(String contextKey) {
        int result = this.delegate.removeDeletedSubscriptions(contextKey);
        if (result > 0) {
            log.debug("Clean cache because the datastore has changed for removeDeletedSubscriptions");
            this.cache.removeAll();
        }
        return result;
    }

    @VisibleForTesting
    static String getCacheKey(long id) {
        return String.valueOf(id);
    }
}

