/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.incrementalsync;

import com.atlassian.confluence.api.model.people.UserKey;
import com.atlassian.confluence.impl.incrementalsync.IncrementalSyncSubscriptionRepository;
import com.atlassian.confluence.incrementalsync.IncrementalSyncSubscriptionEntity;
import com.atlassian.confluence.incrementalsync.IncrementalSyncSubscriptionManager;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncState;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncSubscription;
import com.atlassian.confluence.internal.api.incrementalsync.model.SubscriptionId;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.util.Clock;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIncrementalSyncSubscriptionManager
implements IncrementalSyncSubscriptionManager {
    private static final Logger logger = LoggerFactory.getLogger(DefaultIncrementalSyncSubscriptionManager.class);
    private IncrementalSyncSubscriptionRepository incrementalSyncSubscriptionRepository;
    private final Clock clock;

    public DefaultIncrementalSyncSubscriptionManager(IncrementalSyncSubscriptionRepository incrementalSyncSubscriptionRepository, Clock clock) {
        this.incrementalSyncSubscriptionRepository = incrementalSyncSubscriptionRepository;
        this.clock = clock;
    }

    @Override
    public SubscriptionId store(IncrementalSyncSubscription subscription) {
        Objects.requireNonNull(subscription);
        Optional<IncrementalSyncSubscriptionEntity> existingSubscriptionOptional = Optional.empty();
        if (subscription.getId() > 0L) {
            logger.debug("Loading incremental sync subscription with id {}", (Object)subscription.getId());
            existingSubscriptionOptional = this.incrementalSyncSubscriptionRepository.getSubscriptionById(subscription.getId());
        }
        if (existingSubscriptionOptional.isEmpty()) {
            logger.debug("Creating incremental sync subscription with context key {} and id {}", (Object)subscription.getContextKey(), (Object)subscription.getId());
        }
        IncrementalSyncSubscriptionEntity entity = existingSubscriptionOptional.orElseGet(() -> {
            IncrementalSyncSubscriptionEntity newSubscription = new IncrementalSyncSubscriptionEntity();
            newSubscription.setSubscriber(AuthenticatedUserThreadLocal.get());
            return newSubscription;
        });
        entity.setLastAccessTime(this.clock.getCurrentDate().toInstant());
        DefaultIncrementalSyncSubscriptionManager.extractedData(subscription, entity);
        return SubscriptionId.of((long)this.incrementalSyncSubscriptionRepository.store(entity).getId());
    }

    @Override
    public Optional<IncrementalSyncSubscription> getSubscription(long id) {
        return this.incrementalSyncSubscriptionRepository.getSubscriptionById(id).map(DefaultIncrementalSyncSubscriptionManager::getIncrementalSyncSubscription);
    }

    @Override
    public Collection<IncrementalSyncSubscription> getSubscriptionsByContext(String context) {
        return this.incrementalSyncSubscriptionRepository.findSubscriptionByContextKey(context).stream().map(DefaultIncrementalSyncSubscriptionManager::getIncrementalSyncSubscription).toList();
    }

    @Override
    public Collection<IncrementalSyncSubscription> getSubscriptionsByContext(String context, IncrementalSyncState state) {
        return this.incrementalSyncSubscriptionRepository.findSubscriptionsByContextKeyAndState(context, state).stream().map(DefaultIncrementalSyncSubscriptionManager::getIncrementalSyncSubscription).toList();
    }

    @Override
    public boolean removeSubscription(long id) {
        return this.incrementalSyncSubscriptionRepository.removeSubscriptionById(id) > 0;
    }

    @Override
    public int removeAllSubscriptions(String contextKey) {
        return this.incrementalSyncSubscriptionRepository.removeAllSubscriptionsByContextKey(contextKey);
    }

    @Override
    public int removeExpiredSubscriptions(String contextKey, Instant ttl) {
        return this.incrementalSyncSubscriptionRepository.removeExpiredSubscriptions(contextKey, ttl);
    }

    @Override
    public int removeDeletedSubscriptions(String contextKey) {
        return this.incrementalSyncSubscriptionRepository.removeDeletedSubscriptions(contextKey);
    }

    private static IncrementalSyncSubscription getIncrementalSyncSubscription(IncrementalSyncSubscriptionEntity incrementalSyncSubscriptionEntity) {
        ConfluenceUser subscriber = incrementalSyncSubscriptionEntity.getSubscriber();
        UserKey subscriberUserKey = subscriber == null ? new UserKey() : new UserKey(subscriber.getKey().getStringValue());
        return new IncrementalSyncSubscription(incrementalSyncSubscriptionEntity.getId(), incrementalSyncSubscriptionEntity.getContextKey(), subscriberUserKey, incrementalSyncSubscriptionEntity.getMostRecentId(), IncrementalSyncState.valueOf((String)incrementalSyncSubscriptionEntity.getState()), incrementalSyncSubscriptionEntity.getSubscriptionData(), incrementalSyncSubscriptionEntity.getLastAccessTime());
    }

    private static void extractedData(IncrementalSyncSubscription subscription, IncrementalSyncSubscriptionEntity entity) {
        entity.setContextKey(subscription.getContextKey());
        entity.setState(subscription.getState().name());
        entity.setMostRecentId(subscription.getMostRecentId());
        entity.setSubscriptionData(subscription.getSubscriptionData());
    }
}

