/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.incrementalsync;

import com.atlassian.confluence.event.events.security.SpaceFilteringUpdatedEvent;
import com.atlassian.confluence.impl.incrementalsync.SpaceInclusionsRepository;
import com.atlassian.confluence.incrementalsync.SpaceFilteringManager;
import com.atlassian.confluence.incrementalsync.SpaceInclusionEntity;
import com.atlassian.confluence.security.InvalidOperationException;
import com.atlassian.core.util.Clock;
import com.atlassian.event.api.EventPublisher;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DefaultSpaceFilteringManager
implements SpaceFilteringManager {
    private static final String NO_SPACES_MARKER = "-";
    private final SpaceInclusionsRepository spaceInclusionsRepository;
    private final Clock clock;
    private final EventPublisher eventPublisher;

    public DefaultSpaceFilteringManager(SpaceInclusionsRepository spaceInclusionsRepository, Clock clock, EventPublisher eventPublisher) {
        this.spaceInclusionsRepository = spaceInclusionsRepository;
        this.clock = clock;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void replaceList(Set<String> spaceKeys, boolean optInNewSpaces, String source) {
        Objects.requireNonNull(spaceKeys);
        boolean optOut = !this.isOptedIn();
        this.spaceInclusionsRepository.deleteAll();
        if (!spaceKeys.isEmpty()) {
            for (String spaceKey : spaceKeys) {
                this.addEntity(spaceKey, optInNewSpaces);
            }
        } else {
            this.addEntity(NO_SPACES_MARKER, optInNewSpaces);
        }
        this.eventPublisher.publish((Object)new SpaceFilteringUpdatedEvent(spaceKeys, optInNewSpaces, optOut ? SpaceFilteringUpdatedEvent.UpdateType.OPT_IN : SpaceFilteringUpdatedEvent.UpdateType.UPDATE, source));
    }

    @Override
    public boolean isExcluded(String spaceKey) {
        if (StringUtils.isBlank((CharSequence)Objects.requireNonNull(spaceKey))) {
            throw new IllegalArgumentException("Space key cannot be empty");
        }
        if (!this.isOptedIn()) {
            return false;
        }
        return this.spaceInclusionsRepository.findBySpaceKey(spaceKey).isEmpty();
    }

    @Override
    public void resetList(String source) {
        boolean optOut = !this.isOptedIn();
        this.spaceInclusionsRepository.deleteAll();
        this.eventPublisher.publish((Object)new SpaceFilteringUpdatedEvent(Collections.emptySet(), true, optOut ? SpaceFilteringUpdatedEvent.UpdateType.NO_OP : SpaceFilteringUpdatedEvent.UpdateType.OPT_OUT, source));
    }

    @Override
    public boolean optInNewSpaces() {
        if (!this.isOptedIn()) {
            return true;
        }
        return this.getOptInNewSpacesFlag();
    }

    @Override
    public Set<String> getAllowedSpaces() {
        return this.spaceInclusionsRepository.findAll().stream().map(SpaceInclusionEntity::getSpaceKey).filter(spaceKey -> !NO_SPACES_MARKER.equals(spaceKey)).collect(Collectors.toSet());
    }

    @Override
    public boolean isOptedIn() {
        return this.spaceInclusionsRepository.count() > 0L;
    }

    @Override
    public void addSpace(String key, String source) {
        if (StringUtils.isBlank((CharSequence)Objects.requireNonNull(key))) {
            throw new IllegalArgumentException("Space key cannot be empty");
        }
        if (!this.isOptedIn()) {
            throw new InvalidOperationException("Cannot add space if the space filtering list is disabled");
        }
        this.addEntity(key, this.getOptInNewSpacesFlag());
        this.eventPublisher.publish((Object)new SpaceFilteringUpdatedEvent(Set.of(key), this.optInNewSpaces(), SpaceFilteringUpdatedEvent.UpdateType.UPDATE, source));
    }

    private boolean getOptInNewSpacesFlag() {
        List<Boolean> optInNewSpaces = this.spaceInclusionsRepository.isNewSpacesOptedIn();
        return optInNewSpaces.isEmpty() || optInNewSpaces.getFirst() != false;
    }

    private void addEntity(String spaceKey, boolean optInNewSpaces) {
        SpaceInclusionEntity exclusionEntity = new SpaceInclusionEntity();
        exclusionEntity.setSpaceKey(spaceKey);
        exclusionEntity.setOptInNewSpaces(optInNewSpaces);
        exclusionEntity.setCreationTime(this.clock.getCurrentDate().toInstant());
        this.spaceInclusionsRepository.store(exclusionEntity);
    }
}

