/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.incrementalsync;

import com.atlassian.confluence.incrementalsync.IncrementalSyncSubscriptionEntity;
import com.atlassian.confluence.internal.api.incrementalsync.model.IncrementalSyncState;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

@Repository
public interface IncrementalSyncSubscriptionRepository
extends JpaRepository<IncrementalSyncSubscriptionEntity, Long> {
    default public IncrementalSyncSubscriptionEntity store(IncrementalSyncSubscriptionEntity subscription) {
        return (IncrementalSyncSubscriptionEntity)this.saveAndFlush(subscription);
    }

    public Optional<IncrementalSyncSubscriptionEntity> getSubscriptionById(long var1);

    public List<IncrementalSyncSubscriptionEntity> findSubscriptionByContextKey(String var1);

    public List<IncrementalSyncSubscriptionEntity> findSubscriptionsByContextKeyAndState(String var1, String var2);

    default public List<IncrementalSyncSubscriptionEntity> findSubscriptionsByContextKeyAndState(String contextKey, IncrementalSyncState state) {
        return this.findSubscriptionsByContextKeyAndState(contextKey, state.name());
    }

    public int removeSubscriptionById(long var1);

    @Modifying
    @Query(value="delete from IncrementalSyncSubscriptionEntity s where s.contextKey= ?1")
    public int removeAllSubscriptionsByContextKey(String var1);

    @Modifying
    @Query(value="delete from IncrementalSyncSubscriptionEntity s where s.contextKey=?1 and s.lastAccessTime < ?2")
    public int removeExpiredSubscriptions(String var1, Instant var2);

    @Modifying
    @Query(value="delete from IncrementalSyncSubscriptionEntity s where s.contextKey=?1 and s.state = ?2")
    public int removeSubscriptionsByContextKeyAndState(String var1, String var2);

    default public int removeSubscriptionsByContextKeyAndState(String contextKey, IncrementalSyncState state) {
        return this.removeSubscriptionsByContextKeyAndState(contextKey, state.name());
    }

    default public int removeDeletedSubscriptions(String contextKey) {
        return this.removeSubscriptionsByContextKeyAndState(contextKey, IncrementalSyncState.INACTIVE);
    }
}

