/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.index;

import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.index.IndexJournalService;
import com.atlassian.confluence.api.service.journal.EntryProcessorResult;
import com.atlassian.confluence.impl.journal.DefaultJournalService;
import com.atlassian.confluence.impl.journal.JournalManager;
import com.atlassian.confluence.search.SearchPlatformConfig;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIndexJournalService
extends DefaultJournalService
implements IndexJournalService {
    private static final Logger log = LoggerFactory.getLogger(DefaultIndexJournalService.class);
    private final SearchPlatformConfig searchPlatformConfig;
    private final ClusterLockService clusterLockService;

    public DefaultIndexJournalService(JournalManager journalManager, SearchPlatformConfig searchPlatformConfig, ClusterLockService clusterLockService) {
        super(journalManager);
        this.searchPlatformConfig = searchPlatformConfig;
        this.clusterLockService = clusterLockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> V processNewEntries(@NonNull JournalIdentifier journalId, int maxEntries, @NonNull Function<Iterable<JournalEntry>, EntryProcessorResult<V>> entryProcessor) throws ServiceException {
        Optional<ClusterLock> optionalClusterLock = this.getLockToProcessIfNeeded(journalId);
        if (!optionalClusterLock.map(Lock::tryLock).orElse(true).booleanValue()) {
            log.info("Unable to acquire lock for journal {} to process entries. There could be other node processing the journal", (Object)journalId.getJournalName());
            return (V)entryProcessor.apply(Collections.emptyList()).getResult();
        }
        try {
            V v = super.processNewEntries(journalId, maxEntries, entryProcessor);
            return v;
        }
        finally {
            optionalClusterLock.ifPresent(lock -> {
                log.debug("Releasing lock for journal {} to process entries", (Object)journalId.getJournalName());
                lock.unlock();
                log.debug("Released lock for journal {} to process entries", (Object)journalId.getJournalName());
            });
        }
    }

    private Optional<ClusterLock> getLockToProcessIfNeeded(@NonNull JournalIdentifier journalId) {
        if (this.searchPlatformConfig.isSharedIndex()) {
            log.debug("Lock required to process journal {} due to shared index", (Object)journalId.getJournalName());
            return Optional.of(this.clusterLockService.getLockForName(journalId.getJournalName()));
        }
        log.debug("Lock is not required to process journal {}", (Object)journalId.getJournalName());
        return Optional.empty();
    }
}

