/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.index;

import com.atlassian.confluence.api.model.index.IndexRecoverer;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.index.IndexRecoveryService;
import com.atlassian.confluence.impl.journal.JournalDao;
import com.atlassian.confluence.impl.journal.JournalEntry;
import com.atlassian.confluence.impl.journal.JournalStateStore;
import com.atlassian.confluence.plugin.descriptor.IndexRecovererModuleDescriptor;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.PluginFrameworkResumingEvent;
import com.google.common.annotations.VisibleForTesting;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class NoopIndexRecoveryService
implements IndexRecoveryService,
InitializingBean,
DisposableBean {
    private static final Logger LOG = LoggerFactory.getLogger(NoopIndexRecoveryService.class);
    private final JournalStateStore journalStateStore;
    private final JournalDao journalDao;
    private final EventPublisher eventPublisher;
    private final PluginAccessor pluginAccessor;

    public NoopIndexRecoveryService(JournalStateStore journalStateStore, JournalDao journalDao, EventPublisher eventPublisher, PluginAccessor pluginAccessor) {
        this.journalStateStore = journalStateStore;
        this.journalDao = journalDao;
        this.eventPublisher = eventPublisher;
        this.pluginAccessor = pluginAccessor;
    }

    public boolean isIndexRecoveryRequired(JournalIdentifier journalId, String indexDirName) {
        return false;
    }

    public boolean recoverIndex(JournalIdentifier journalId, String indexDirName) {
        return false;
    }

    public boolean recoverIndexFromSharedHome(JournalIdentifier journalId, String indexDirName) {
        return false;
    }

    public boolean createIndexBackup(JournalIdentifier journalId, String indexDirName, IndexRecoverer indexRecoverer) {
        return true;
    }

    @VisibleForTesting
    void triggerIndexRecovererModuleDescriptors() {
        List indexRecoverers = this.pluginAccessor.getEnabledModuleDescriptorsByClass(IndexRecovererModuleDescriptor.class);
        for (IndexRecovererModuleDescriptor indexRecoverer : indexRecoverers) {
            try {
                JournalIdentifier journalId = indexRecoverer.getJournalId();
                long journalEntryId = this.journalStateStore.getMostRecentId(journalId);
                if (journalEntryId == 0L) {
                    if (this.journalDao.findLatestEntry(journalId, 0L).isPresent()) {
                        LOG.warn("journalEntryId for {} was 0, you may need to rebuild the index", (Object)journalId.getJournalName());
                    }
                    return;
                }
                JournalEntry entry = this.journalDao.findEntry(journalEntryId);
                if (entry != null) continue;
                LOG.warn("journal entry {} not found for {}, you may need to rebuild the index", (Object)journalEntryId, (Object)journalId.getJournalName());
            }
            catch (Exception e) {
                LOG.error("Exception when handling index recovery for module descriptor {}", (Object)indexRecoverer.getCompleteKey(), (Object)e);
            }
        }
    }

    @EventListener
    public void handleStartingEvent(PluginFrameworkResumingEvent event) {
        this.triggerIndexRecovererModuleDescriptors();
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

