/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.journal;

import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.exceptions.ServiceException;
import com.atlassian.confluence.api.service.journal.EntryProcessorResult;
import com.atlassian.confluence.impl.journal.JournalDao;
import com.atlassian.confluence.impl.journal.JournalEntry;
import com.atlassian.confluence.impl.journal.JournalManager;
import com.atlassian.confluence.impl.journal.JournalStateStore;
import com.atlassian.confluence.search.SearchPlatformConfig;
import com.atlassian.confluence.test.JournalManagerBackdoor;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class DefaultJournalManager
implements JournalManager {
    private static final Integer JOURNAL_MAX_TRY_TIMES = Integer.getInteger("journal.max.try.times", 3);
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJournalManager.class);
    private final JournalDao journalDao;
    private final JournalStateStore journalStateStore;
    private final IgnoreSettings ignoreSettings;
    private final SearchPlatformConfig searchPlatformConfig;
    private final PlatformTransactionManager transactionManager;

    public DefaultJournalManager(JournalDao journalDao, JournalStateStore journalStateStore, IgnoreSettings ignoreSettings, SearchPlatformConfig searchPlatformConfig, PlatformTransactionManager transactionManager) {
        this.journalDao = (JournalDao)Preconditions.checkNotNull((Object)journalDao);
        this.journalStateStore = (JournalStateStore)Preconditions.checkNotNull((Object)journalStateStore);
        this.ignoreSettings = ignoreSettings;
        this.searchPlatformConfig = (SearchPlatformConfig)Preconditions.checkNotNull((Object)searchPlatformConfig);
        this.transactionManager = (PlatformTransactionManager)Preconditions.checkNotNull((Object)transactionManager);
    }

    @Override
    public long enqueue(@NonNull JournalEntry entry) {
        Preconditions.checkArgument((entry.getId() == 0L ? 1 : 0) != 0, (Object)"Cannot enqueue a JournalEntry if it already has an ID");
        JournalIdentifier journalId = entry.getJournalId();
        Long mostRecentId = null;
        if (!this.searchPlatformConfig.isSharedIndex()) {
            mostRecentId = this.journalStateStore.getMostRecentId(journalId);
        }
        long newEntryId = this.journalDao.enqueue(entry);
        LOGGER.debug("Enqueued JournalEntry: {}", (Object)entry);
        if (mostRecentId != null && newEntryId <= mostRecentId) {
            LOGGER.warn("Newly enqueued entry in journal [{}] has an ID [{}] that should have been higher than the journal state store's most-recent-id [{}]. it is likely that this node's journal state store is corrupt.", new Object[]{journalId.getJournalName(), newEntryId, mostRecentId});
        }
        return newEntryId;
    }

    @Override
    public void enqueue(@NonNull Collection<JournalEntry> entries) throws ServiceException {
        entries.stream().filter(entry -> entry.getId() != 0L).findAny().ifPresent(entry -> {
            throw new IllegalArgumentException("Cannot enqueue a JournalEntry if it already has an ID");
        });
        this.journalDao.enqueue(entries);
    }

    @Override
    public Iterable<JournalEntry> peek(@NonNull JournalIdentifier journalId, int maxEntries) {
        long mostRecentId = this.journalStateStore.getMostRecentId(journalId);
        return this.journalDao.findEntries(journalId, mostRecentId, 0L, maxEntries);
    }

    @Override
    public void reset(@NonNull JournalIdentifier journalId) {
        this.journalDao.findLatestEntry(journalId, 0L).map(JournalEntry::getId).ifPresent(entryId -> this.journalStateStore.setMostRecentId(journalId, (long)entryId));
    }

    @Override
    public int countEntries(@NonNull JournalIdentifier journalId) {
        long mostRecentId = this.journalStateStore.getMostRecentId(journalId);
        return this.journalDao.countEntries(journalId, mostRecentId, 0L);
    }

    @Override
    public <V> V processNewEntries(@NonNull JournalIdentifier journalId, int maxEntries, @NonNull Function<Iterable<JournalEntry>, @NonNull EntryProcessorResult<V>> entryProcessor) throws DataAccessException {
        long mostRecentId = this.journalStateStore.getMostRecentId(journalId);
        List<JournalEntry> entries = this.journalDao.findEntries(journalId, mostRecentId, this.ignoreSettings.ignoreWithinMillis, maxEntries);
        EntryProcessorResult<V> result = entryProcessor.apply(entries);
        this.updateMostRecentId(journalId, entries, result);
        return (V)result.getResult();
    }

    @Override
    public void waitForRecentEntriesToBecomeVisible() throws InterruptedException {
        long sleepTime = this.ignoreSettings.ignoreWithinMillis + 100L;
        LOGGER.debug("Sleeping for {} ms in order to make recent entries visible", (Object)sleepTime);
        Thread.sleep(sleepTime);
    }

    @Override
    public long getIgnoreWithinMillis() {
        return this.ignoreSettings.ignoreWithinMillis;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateMostRecentId(JournalIdentifier journalId, List<JournalEntry> entries, EntryProcessorResult<?> result) {
        long mostRecentId;
        List<Long> entryIds = entries.stream().map(JournalEntry::getId).collect(Collectors.toList());
        if (entries.isEmpty()) {
            return;
        }
        if (result.getLastSuccessfulId() != null) {
            if (!entryIds.contains(result.getLastSuccessfulId())) throw new IllegalArgumentException("lastSuccessfulId did not match any JournalEntries");
            mostRecentId = result.getLastSuccessfulId();
        } else if (result.getFailedEntryId() != null) {
            mostRecentId = this.handleFailedEntry(entries, result, entryIds);
            if (mostRecentId == -1L) {
                return;
            }
        } else {
            mostRecentId = ((JournalEntry)Iterables.getLast(entries)).getId();
        }
        this.journalStateStore.setMostRecentId(journalId, mostRecentId);
    }

    private long handleFailedEntry(List<JournalEntry> entries, EntryProcessorResult<?> result, List<Long> entryIds) {
        int failureIndex = entryIds.indexOf(result.getFailedEntryId());
        if (failureIndex == -1) {
            throw new IllegalArgumentException("failedEntryId did not match any JournalEntries");
        }
        JournalEntry failedEntry = entries.get(failureIndex);
        if (failedEntry.getTriedTimes() >= JOURNAL_MAX_TRY_TIMES - 1) {
            LOGGER.warn("Entry in journal [{}] with ID [{}] has reached the maximum try times ({}), skipping it", new Object[]{failedEntry.getJournalId().getJournalName(), failedEntry.getId(), JOURNAL_MAX_TRY_TIMES});
            return failedEntry.getId();
        }
        this.updateFailedEntry(failedEntry);
        if (failureIndex == 0) {
            return -1L;
        }
        return entries.get(failureIndex - 1).getId();
    }

    private void updateFailedEntry(JournalEntry failedEntry) {
        failedEntry.setTriedTimes(failedEntry.getTriedTimes() + 1);
        if (TransactionSynchronizationManager.isActualTransactionActive() && TransactionSynchronizationManager.isCurrentTransactionReadOnly()) {
            DefaultTransactionAttribute transactionDefinition = new DefaultTransactionAttribute(3);
            new TransactionTemplate(this.transactionManager, (TransactionDefinition)transactionDefinition).execute(status -> {
                this.journalDao.updateEntry(failedEntry);
                return null;
            });
        } else {
            this.journalDao.updateEntry(failedEntry);
        }
    }

    @Override
    public Optional<JournalEntry> getMostRecentId(@NonNull JournalIdentifier journalIdentifier) throws DataAccessException {
        return this.journalDao.findLatestEntry(journalIdentifier, this.getIgnoreWithinMillis());
    }

    @Override
    public void setMostRecentId(@NonNull JournalIdentifier journalIdentifier, long id) throws DataAccessException {
        this.journalStateStore.setMostRecentId(journalIdentifier, id);
    }

    @Override
    public void setMostRecentId(@NonNull JournalEntry journalEntry) throws DataAccessException {
        this.setMostRecentId(journalEntry.getJournalId(), journalEntry.getId());
    }

    @Override
    public int removeEntriesOlderThanExclusive(@NonNull Date date, Collection<String> excludingJournalNames) {
        return this.journalDao.removeEntriesOlderThanExclusive(date, excludingJournalNames);
    }

    @Override
    public int removeEntriesOlderThanInclusive(@NonNull Date date, Collection<String> journalNames) {
        return this.journalDao.removeEntriesOlderThanInclusive(date, journalNames);
    }

    public static class IgnoreSettings
    implements JournalManagerBackdoor {
        private long ignoreWithinMillis;

        public IgnoreSettings(long ignoreWithinMillis) {
            this.ignoreWithinMillis = ignoreWithinMillis;
        }

        @Override
        public long getIgnoreWithinMillis() {
            return this.ignoreWithinMillis;
        }

        @Override
        @VisibleForTesting
        public void setIgnoreWithinMillis(long ignoreWithinMillis) {
            this.ignoreWithinMillis = ignoreWithinMillis;
        }
    }
}

