/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.journal;

import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.impl.journal.JournalDao;
import com.atlassian.confluence.impl.journal.JournalEntry;
import com.atlassian.core.util.Clock;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class HibernateJournalDao
implements JournalDao {
    private static final Logger log = LoggerFactory.getLogger(HibernateJournalDao.class);
    private final SessionFactory sessionFactory;
    private final Clock clock;

    public HibernateJournalDao(SessionFactory sessionFactory, Clock clock) {
        this.sessionFactory = sessionFactory;
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
    }

    @Override
    public long enqueue(@NonNull JournalEntry entry) {
        entry.setCreationDate(this.clock.getCurrentDate());
        return (Long)this.sessionFactory.getCurrentSession().save((Object)entry);
    }

    @Override
    public void enqueue(@NonNull Collection<JournalEntry> entries) {
        log.trace("Enqueuing of {} entries started", (Object)entries.size());
        entries.forEach(this::enqueue);
        log.trace("Enqueuing of {} entries has been finished", (Object)entries.size());
    }

    @Override
    public List<JournalEntry> findEntries(@NonNull JournalIdentifier journalId, long afterId, long ignoreWithinMillis, int maxEntries) {
        Preconditions.checkArgument((maxEntries > 0 ? 1 : 0) != 0, (Object)"maxEntries must be a bigger than 0");
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.journal_findEntriesLaterThan", JournalEntry.class).setMaxResults(maxEntries).setParameter("entryId", (Object)afterId).setParameter("journalName", (Object)journalId).setParameter("creationDate", (Object)this.since(ignoreWithinMillis)).list();
    }

    @Override
    @VisibleForTesting
    public Optional<JournalEntry> findMostRecentEntryByMessage(@NonNull JournalIdentifier journalId, String message) {
        Preconditions.checkNotNull((Object)message, (Object)"message must be a non-null");
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.journal_findEntriesByMessage", JournalEntry.class).setParameter("journalName", (Object)journalId).setParameter("message", (Object)message).stream().findFirst();
    }

    @Override
    public int removeEntriesOlderThan(@NonNull Date date) {
        List latestEntryIds = this.sessionFactory.getCurrentSession().createNamedQuery("confluence.journal_findLatestEntryForJournals", Long.class).list();
        if (latestEntryIds.isEmpty()) {
            return 0;
        }
        return this.removeEntriesOlderThan(date, latestEntryIds);
    }

    @Override
    public int removeEntriesOlderThanExclusive(@NonNull Date date, Collection<String> excludingJournalNames) {
        this.sessionFactory.getCurrentSession().flush();
        SessionImplementor session = (SessionImplementor)this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaDelete delete = session.getCriteriaBuilder().createCriteriaDelete(JournalEntry.class);
        Root root = delete.from(JournalEntry.class);
        delete.where(new Predicate[]{builder.lessThan((Expression)root.get("creationDate"), (Comparable)date), builder.not((Expression)root.get("journalId").in(excludingJournalNames))});
        return session.createQuery(delete).executeUpdate();
    }

    @Override
    public int removeEntriesOlderThanInclusive(@NonNull Date date, Collection<String> journalNames) {
        this.sessionFactory.getCurrentSession().flush();
        SessionImplementor session = (SessionImplementor)this.sessionFactory.getCurrentSession();
        CriteriaBuilder builder = session.getCriteriaBuilder();
        CriteriaDelete delete = session.getCriteriaBuilder().createCriteriaDelete(JournalEntry.class);
        Root root = delete.from(JournalEntry.class);
        delete.where(new Predicate[]{builder.lessThan((Expression)root.get("creationDate"), (Comparable)date), root.get("journalId").in(journalNames)});
        return session.createQuery(delete).executeUpdate();
    }

    private int removeEntriesOlderThan(Date date, Collection<Long> excludingIds) {
        this.sessionFactory.getCurrentSession().flush();
        Session session = this.sessionFactory.getCurrentSession();
        return (Integer)session.doReturningWork(connection -> {
            SingleConnectionDataSource dataSource = new SingleConnectionDataSource(connection, true);
            return new NamedParameterJdbcTemplate((DataSource)dataSource).update("DELETE FROM journalentry WHERE creationdate < :date and entry_id not in (:ids)", (SqlParameterSource)new MapSqlParameterSource().addValue("date", (Object)date).addValue("ids", (Object)excludingIds));
        });
    }

    @Override
    public Optional<JournalEntry> findLatestEntry(@NonNull JournalIdentifier journalId, long ignoreWithinMillis) {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.journal_findLatestEntries", JournalEntry.class).setMaxResults(1).setParameter("journalName", (Object)journalId).setParameter("creationDate", (Object)this.since(ignoreWithinMillis)).stream().findFirst();
    }

    @Override
    public Optional<JournalEntry> findEarliestEntry() {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.journal_findEarliestEntry", JournalEntry.class).stream().findFirst();
    }

    @Override
    public JournalEntry findEntry(long entryId) {
        return (JournalEntry)this.sessionFactory.getCurrentSession().get(JournalEntry.class, (Serializable)Long.valueOf(entryId));
    }

    @Override
    public int countEntries(@NonNull JournalIdentifier journalId, long afterId, long ignoreWithinMillis) {
        return (Integer)this.sessionFactory.getCurrentSession().createNamedQuery("confluence.journal_countEntriesLaterThan", Integer.class).setParameter("entryId", (Object)afterId).setParameter("journalName", (Object)journalId).setParameter("creationDate", (Object)this.since(ignoreWithinMillis)).stream().findFirst().orElseThrow();
    }

    @Override
    public void updateEntry(JournalEntry journalEntry) {
        this.sessionFactory.getCurrentSession().update((Object)journalEntry);
    }

    private Date since(long ignoreWithinMillis) {
        return new Date(this.clock.getCurrentDate().getTime() - ignoreWithinMillis);
    }
}

