/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.journal;

import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.index.IndexRecoveryService;
import com.atlassian.confluence.cluster.ClusterConfigurationHelper;
import com.atlassian.confluence.impl.journal.JournalServiceInternal;
import com.atlassian.confluence.internal.api.service.incrementalsync.IncrementalSyncCleaner;
import com.atlassian.confluence.plugin.descriptor.IndexRecovererModuleDescriptor;
import com.atlassian.confluence.util.DefaultClock;
import com.atlassian.core.util.Clock;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.google.common.base.Preconditions;
import java.util.Date;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalCleaner
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(JournalCleaner.class);
    private final ClusterConfigurationHelper clusterConfigurationHelper;
    private final PluginAccessor pluginAccessor;
    private final IndexRecoveryService indexRecoveryService;
    private final JournalServiceInternal journalServiceInternal;
    private final Clock clock;
    private final long defaultTimeToLiveMillis;
    private final List<IncrementalSyncCleaner> incrementalSyncCleaners;

    public JournalCleaner(ClusterConfigurationHelper clusterConfigurationHelper, PluginAccessor pluginAccessor, IndexRecoveryService indexRecoveryService, JournalServiceInternal journalServiceInternal, long defaultTimeToLiveMillis, List<IncrementalSyncCleaner> incrementalSyncCleaners) {
        this(clusterConfigurationHelper, pluginAccessor, indexRecoveryService, journalServiceInternal, (Clock)new DefaultClock(), defaultTimeToLiveMillis, incrementalSyncCleaners);
    }

    public JournalCleaner(ClusterConfigurationHelper clusterConfigurationHelper, PluginAccessor pluginAccessor, IndexRecoveryService indexRecoveryService, JournalServiceInternal journalServiceInternal, Clock clock, long defaultTimeToLiveMillis, List<IncrementalSyncCleaner> incrementalSyncCleaners) {
        this.clock = (Clock)Preconditions.checkNotNull((Object)clock);
        this.clusterConfigurationHelper = (ClusterConfigurationHelper)Preconditions.checkNotNull((Object)clusterConfigurationHelper);
        this.pluginAccessor = (PluginAccessor)Preconditions.checkNotNull((Object)pluginAccessor);
        this.indexRecoveryService = (IndexRecoveryService)Preconditions.checkNotNull((Object)indexRecoveryService);
        this.journalServiceInternal = (JournalServiceInternal)Preconditions.checkNotNull((Object)journalServiceInternal);
        Preconditions.checkArgument((defaultTimeToLiveMillis > 0L ? 1 : 0) != 0);
        this.defaultTimeToLiveMillis = defaultTimeToLiveMillis;
        this.incrementalSyncCleaners = (List)Preconditions.checkNotNull(incrementalSyncCleaners);
    }

    public @Nullable JobRunnerResponse runJob(JobRunnerRequest request) {
        boolean snapshot = this.snapshotIndexJournalEntries();
        int count = this.cleanupIndexJournalEntries();
        return JobRunnerResponse.success((String)("Snapshot = " + snapshot + ", expired entry count = " + count));
    }

    private boolean snapshotIndexJournalEntries() {
        boolean shouldSnapshot;
        String property = System.getProperty("create.index.backups");
        boolean bl = shouldSnapshot = property == null ? this.clusterConfigurationHelper.isClusterHomeConfigured() : Boolean.parseBoolean(property);
        if (shouldSnapshot) {
            this.pluginAccessor.getEnabledModuleDescriptorsByClass(IndexRecovererModuleDescriptor.class).forEach(desc -> {
                try {
                    if (!this.indexRecoveryService.createIndexBackup(desc.getJournalId(), desc.getIndexDirName(), desc.getModule())) {
                        log.error("Could not back up index: {}", (Object)desc.getIndexName());
                    }
                }
                catch (RuntimeException e) {
                    log.error("Could not back up index: {}", (Object)desc.getIndexName(), (Object)e);
                }
            });
        }
        return shouldSnapshot;
    }

    private int cleanupIndexJournalEntries() {
        long ttl = Long.getLong("com.atlassian.confluence.journal.timeToLiveInMillis", this.defaultTimeToLiveMillis);
        List<String> incrementalSyncJournalNames = this.incrementalSyncCleaners.stream().flatMap(incrementalSyncCleaner -> incrementalSyncCleaner.getManagedJournalIdentifier().stream().map(JournalIdentifier::getJournalName)).toList();
        if (log.isDebugEnabled()) {
            log.debug("Journal names that should be cleaned {}", (Object)String.join((CharSequence)", ", incrementalSyncJournalNames));
        }
        int affectedEntry = this.journalServiceInternal.removeEntriesOlderThanExclusive(new Date(this.clock.getCurrentDate().getTime() - ttl), incrementalSyncJournalNames);
        this.incrementalSyncCleaners.forEach(IncrementalSyncCleaner::cleanObsoleteData);
        return affectedEntry;
    }
}

