/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.journal;

import com.atlassian.confluence.event.events.admin.ImportFinishedEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.impl.journal.JournalStateStore;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventListenerRegistrar;
import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;

public class JournalStateResettingListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(JournalStateResettingListener.class);
    private final EventListenerRegistrar eventListenerRegistrar;
    private final JournalStateStore journalStateStore;

    public JournalStateResettingListener(EventListenerRegistrar eventListenerRegistrar, JournalStateStore journalStateStore) {
        this.eventListenerRegistrar = (EventListenerRegistrar)Preconditions.checkNotNull((Object)eventListenerRegistrar);
        this.journalStateStore = (JournalStateStore)Preconditions.checkNotNull((Object)journalStateStore);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventListenerRegistrar.register((Object)this);
    }

    @EventListener
    public void onEvent(ClusterEventWrapper eventWrapper) {
        ImportFinishedEvent event;
        ClusterEvent clusterEvent = eventWrapper.getEvent();
        if (clusterEvent instanceof ImportFinishedEvent && (event = (ImportFinishedEvent)clusterEvent).isSiteImport()) {
            log.info("Reset journal states in response to import event");
            try {
                this.journalStateStore.resetAllJournalStates();
            }
            catch (DataAccessException e) {
                log.error("Import failed: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public void destroy() throws Exception {
        this.eventListenerRegistrar.unregister((Object)this);
    }
}

