/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.journal;

import com.atlassian.annotations.Internal;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.settings.ExtendedPluginSettings;
import com.atlassian.confluence.api.service.settings.ExtendedPluginSettingsFactory;
import com.atlassian.confluence.impl.journal.JournalStateStore;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.springframework.dao.DataAccessException;

@Internal
public class PluginSettingsJournalStateStore
implements JournalStateStore {
    private final ExtendedPluginSettings pluginSettings;

    public PluginSettingsJournalStateStore(ExtendedPluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createSettingsForKey("com.atlassian.confluence.impl.journal.JournalBandanaContext");
    }

    @Override
    public long getMostRecentId(@NonNull JournalIdentifier journalId) throws DataAccessException {
        Long value = (Long)this.pluginSettings.get(journalId.getJournalName());
        return Objects.requireNonNullElse(value, 0L);
    }

    @Override
    public void setMostRecentId(@NonNull JournalIdentifier journalId, long id) throws DataAccessException {
        this.pluginSettings.put(journalId.getJournalName(), (Object)id);
    }

    @Override
    public void resetAllJournalStates() throws DataAccessException {
        this.pluginSettings.getKeys().forEach(arg_0 -> ((ExtendedPluginSettings)this.pluginSettings).remove(arg_0));
    }
}

