/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.jsonator;

import com.atlassian.confluence.core.ContextPathHolder;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.datetime.DateFormatterFactory;
import com.atlassian.confluence.json.jsonator.DefaultJsonatorFactory;
import com.atlassian.confluence.json.jsonator.Jsonator;
import com.atlassian.confluence.json.jsonator.JsonatorFactory;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.thumbnail.ThumbnailManager;
import com.atlassian.confluence.user.UserPreferencesAccessor;
import com.atlassian.confluence.user.UserProfilePictureAccessor;
import com.atlassian.confluence.util.i18n.DocumentationBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import jakarta.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration
class JsonatorConfig {
    @Resource
    private FormatSettingsManager formatSettingsManager;
    @Resource
    private LocaleManager localeManager;
    @Resource
    private ContextPathHolder contextPathHolder;
    @Resource
    private ThumbnailManager thumbnailManager;
    @Resource
    private I18NBeanFactory userI18NBeanFactory;
    @Resource
    private DateFormatterFactory dateFormatterFactory;
    @Resource
    private UserProfilePictureAccessor userProfilePictureAccessor;
    @Resource
    private DocumentationBean docBean;
    @Resource
    private UserPreferencesAccessor userPreferencesAccessor;

    JsonatorConfig() {
    }

    @Bean
    @Scope(value="prototype", proxyMode=ScopedProxyMode.INTERFACES)
    public Jsonator<?> jsonator() {
        return this.jsonatorFactory().createJsonator();
    }

    @Bean
    public JsonatorFactory<?> jsonatorFactory() {
        return new DefaultJsonatorFactory(this.formatSettingsManager, this.localeManager, this.contextPathHolder, this.userI18NBeanFactory, this.userProfilePictureAccessor, this.docBean, this.userPreferencesAccessor, this.dateFormatterFactory, this.thumbnailManager);
    }
}

