/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.labels;

import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.core.SearchContext;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelPermissionEnforcer;
import com.atlassian.confluence.labels.Labelable;
import com.atlassian.confluence.labels.Namespace;
import com.atlassian.confluence.labels.NamespaceLabelFilter;
import com.atlassian.confluence.labels.ParsedLabelName;
import com.atlassian.confluence.labels.PermittedLabelView;
import com.atlassian.confluence.labels.SpecialLabelFilter;
import com.atlassian.confluence.labels.VisibleLabelFilter;
import com.atlassian.confluence.search.v2.ContentSearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchManager;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SiteSearchPermissionsQueryFactory;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.LabelQuery;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.core.util.filter.Filter;
import com.atlassian.core.util.filter.FilterChain;
import com.atlassian.core.util.filter.ListFilter;
import com.atlassian.user.User;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LabelPermissionEnforcerImpl
implements LabelPermissionEnforcer {
    private final PermissionManager permissionManager;
    private final AccessModeService accessModeService;
    private final SiteSearchPermissionsQueryFactory siteSearchPermissionsQueryFactory;
    private final SpaceManagerInternal spaceManager;
    private final SearchManager searchManager;
    private static final Logger log = LoggerFactory.getLogger(LabelPermissionEnforcerImpl.class);

    public LabelPermissionEnforcerImpl(PermissionManager permissionManager, AccessModeService accessModeService, SiteSearchPermissionsQueryFactory siteSearchPermissionsQueryFactory, SpaceManagerInternal spaceManager, SearchManager searchManager) {
        this.permissionManager = permissionManager;
        this.accessModeService = accessModeService;
        this.siteSearchPermissionsQueryFactory = siteSearchPermissionsQueryFactory;
        this.spaceManager = spaceManager;
        this.searchManager = searchManager;
    }

    @Override
    public boolean isLabelableByUser(Labelable object) {
        if (this.accessModeService.shouldEnforceReadOnlyAccess()) {
            return false;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission(user, Permission.EDIT, object) || user != null && this.permissionManager.hasPermission(user, Permission.VIEW, object);
    }

    @Override
    public boolean userCanEditLabel(ParsedLabelName ref, Labelable object) {
        if (this.accessModeService.shouldEnforceReadOnlyAccess()) {
            return false;
        }
        if (object instanceof PermittedLabelView) {
            return this.userCanEditLabel(ref, ((PermittedLabelView)object).getDelegate());
        }
        if (!this.userCanViewObject(object)) {
            return false;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return !(ref.getOwner() == null ? !this.permissionManager.hasPermission(user, Permission.EDIT, object) : user == null || !this.permissionManager.hasPermission(user, Permission.VIEW, object));
    }

    @Override
    public boolean userCanEditLabel(Label label, Labelable object) {
        if (this.accessModeService.shouldEnforceReadOnlyAccess()) {
            return false;
        }
        if (object instanceof PermittedLabelView) {
            return this.userCanEditLabel(label, ((PermittedLabelView)object).getDelegate());
        }
        if (!this.userCanViewObject(object)) {
            return false;
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (Namespace.isPersonal(label)) {
            return null != user && this.permissionManager.hasPermission(user, Permission.VIEW, object);
        }
        return this.permissionManager.hasPermission(user, Permission.EDIT, object);
    }

    @Override
    public boolean userCanEditLabelOrIsSpaceAdmin(Label label, SpaceContentEntityObject object) {
        if (this.accessModeService.shouldEnforceReadOnlyAccess()) {
            return false;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        return this.userEquals(label.getOwnerUser(), currentUser) && this.userCanEditLabel(label, (Labelable)object) || this.permissionManager.hasPermission(currentUser, Permission.ADMINISTER, object.getSpace());
    }

    @Override
    public boolean userCanViewObject(Labelable object) {
        if (object == null) {
            return false;
        }
        if (object instanceof PermittedLabelView) {
            return this.userCanViewObject(((PermittedLabelView)object).getDelegate());
        }
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        return this.permissionManager.hasPermission(user, Permission.VIEW, object);
    }

    private boolean userEquals(@Nullable User x, @Nullable User y) {
        return x == y || x != null && x.equals((Object)y);
    }

    @Override
    public List filterVisibleLabels(List labelList, @Nullable User user, boolean hideSpecialLabels) {
        FilterChain filters = new FilterChain();
        VisibleLabelFilter visibleLabelFilter = user != null ? new VisibleLabelFilter(user.getName()) : new VisibleLabelFilter();
        filters.addFilter((Filter)visibleLabelFilter);
        if (hideSpecialLabels) {
            filters.addFilter((Filter)new SpecialLabelFilter());
        }
        ListFilter listFilter = new ListFilter((Filter)filters);
        return listFilter.filterList(labelList);
    }

    private BooleanQuery.Builder getContentSearchQuery(Label label) {
        HashSet<SearchQuery> searchQueries = new HashSet<SearchQuery>();
        searchQueries.add(new LabelQuery(label.getDisplayTitle()));
        SearchContext searchContext = SearchContext.getDefaultSearchContext();
        searchContext.setPermissionExempt(false);
        searchQueries.add(this.siteSearchPermissionsQueryFactory.create(searchContext));
        SearchQuery combinedQuery = BooleanQuery.composeAndQuery(searchQueries);
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.addMust(combinedQuery);
        return queryBuilder;
    }

    @Override
    public boolean userCanViewLabel(Label label) {
        ContentSearch.Builder contentSearchQueryBuilder = (ContentSearch.Builder)((ContentSearch.Builder)((ContentSearch.Builder)((ContentSearch.Builder)ContentSearch.builder().query(this.getContentSearchQuery(label).build())).sort(TitleSort.DEFAULT)).startOffset(0)).limit(1);
        try {
            SearchResults results = this.searchManager.search(contentSearchQueryBuilder.build());
            return results.size() > 0;
        }
        catch (InvalidSearchException e) {
            log.error("Unable to perform content search: ", (Throwable)e);
            return false;
        }
    }

    @Override
    public boolean userCanViewTeamLabel(Label label) {
        SpacesQuery query = SpacesQuery.newQuery().withLabel(label).forUser(AuthenticatedUserThreadLocal.get()).build();
        List spaces = this.spaceManager.getSpaces(query, LimitedRequestImpl.create((int)1), new Predicate[0]).getResults();
        return !spaces.isEmpty();
    }

    @Override
    public List<Label> filterAuthorizedLabels(List<Label> labels) {
        return labels.stream().filter(label -> label.isTeamLabel() ? this.userCanViewTeamLabel((Label)label) : this.userCanViewLabel((Label)label)).collect(Collectors.toList());
    }

    @Override
    public List filterLabelsByNamespace(List labelList, @Nullable User user, Namespace namespace) {
        FilterChain filters = new FilterChain();
        NamespaceLabelFilter namespaceLabelFilter = user != null ? new NamespaceLabelFilter(namespace, user.getName()) : new NamespaceLabelFilter(namespace);
        filters.addFilter((Filter)namespaceLabelFilter);
        ListFilter listFilter = new ListFilter((Filter)filters);
        return listFilter.filterList(labelList);
    }
}

