/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.labels.adaptivelabelcache.dao;

import com.atlassian.confluence.impl.labels.adaptivelabelcache.LiteSearchResultCacheEntry;
import com.atlassian.confluence.impl.labels.adaptivelabelcache.dao.AdaptiveLabelCacheDao;
import com.atlassian.confluence.impl.labels.adaptivelabelcache.dao.MostUsedLabelsCacheRecord;
import com.atlassian.confluence.labels.dto.LiteLabelSearchResult;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.persistence.dao.SpaceDao;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import org.hibernate.SessionFactory;

public class DatabaseBasedAdaptiveLabelCacheDaoImpl
implements AdaptiveLabelCacheDao {
    private final SessionFactory sessionFactory;
    private final SpaceDao spaceDao;
    private final Gson gson = new Gson();

    public DatabaseBasedAdaptiveLabelCacheDaoImpl(SessionFactory sessionFactory, SpaceDao spaceDao) {
        this.sessionFactory = sessionFactory;
        this.spaceDao = spaceDao;
    }

    @Override
    public LiteSearchResultCacheEntry read(long spaceId) {
        MostUsedLabelsCacheRecord cacheRecord = (MostUsedLabelsCacheRecord)this.sessionFactory.getCurrentSession().find(MostUsedLabelsCacheRecord.class, (Object)spaceId);
        if (cacheRecord == null) {
            return null;
        }
        if (1 != cacheRecord.getVersion()) {
            return null;
        }
        List<LiteLabelSearchResult> labels = this.deserialiseLabels(cacheRecord.getLabels());
        return new LiteSearchResultCacheEntry(labels, cacheRecord.getRequestLimit(), cacheRecord.getExpirationTs(), cacheRecord.getRequestTs());
    }

    @Override
    public void clear() {
        this.sessionFactory.getCurrentSession().createQuery("delete from MostUsedLabelsCacheRecord").executeUpdate();
    }

    @Override
    public void removeRecordsExpiredAfter(long timestamp) {
        this.sessionFactory.getCurrentSession().createQuery("delete from MostUsedLabelsCacheRecord where expirationTs < :ts").setParameter("ts", (Object)timestamp).executeUpdate();
    }

    @Override
    public void removeRecord(long spaceId) {
        this.sessionFactory.getCurrentSession().createQuery("delete from MostUsedLabelsCacheRecord where spaceId = :spaceId").setParameter("spaceId", (Object)spaceId).executeUpdate();
    }

    @Override
    public void write(long spaceId, LiteSearchResultCacheEntry cacheEntry) {
        MostUsedLabelsCacheRecord dbCacheRecord = new MostUsedLabelsCacheRecord();
        dbCacheRecord.setRequestTs(cacheEntry.getRequestTs());
        dbCacheRecord.setExpirationTs(cacheEntry.getExpirationTs());
        dbCacheRecord.setLabels(this.serialiseLabels(cacheEntry.getList()));
        dbCacheRecord.setRequestLimit(cacheEntry.getRequestedLimit());
        dbCacheRecord.setSpaceId(spaceId);
        dbCacheRecord.setVersion(1);
        this.sessionFactory.getCurrentSession().saveOrUpdate((Object)dbCacheRecord);
    }

    private List<LiteLabelSearchResult> deserialiseLabels(String labels) {
        return (List)this.gson.fromJson(labels, new TypeToken<List<LiteLabelSearchResult>>(this){}.getType());
    }

    private String serialiseLabels(List<LiteLabelSearchResult> list) {
        return this.gson.toJson(list);
    }

    @Override
    public String getSpaceKeyFromSpaceId(long spaceId) {
        Space space = this.spaceDao.getById(spaceId);
        if (space == null) {
            throw new RuntimeException("A space with '" + spaceId + "' id does not exist");
        }
        return space.getKey();
    }

    @Override
    public long getSpaceIdByKey(String spaceKey) {
        Space space = this.spaceDao.getSpace(spaceKey);
        if (space == null) {
            throw new RuntimeException("A space with '" + spaceKey + "' key does not exist");
        }
        return space.getId();
    }
}

