/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.like;

import com.atlassian.annotations.nullability.ParametersAreNonnullByDefault;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.datetime.RequestTimeThreadLocal;
import com.atlassian.confluence.impl.like.LikeEntityDao;
import com.atlassian.confluence.like.LikeEntity;
import com.atlassian.confluence.user.ConfluenceUser;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.Query;
import org.springframework.dao.support.DataAccessUtils;

@ParametersAreNonnullByDefault
public class HibernateLikeEntityDao
implements LikeEntityDao {
    private final SessionFactoryImplementor sessionFactory;

    public HibernateLikeEntityDao(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public LikeEntity addLike(ContentEntityObject contentEntity, ConfluenceUser user) {
        LikeEntity likeEntity = new LikeEntity(contentEntity, user, RequestTimeThreadLocal.getTimeOrNow());
        this.sessionFactory.getCurrentSession().save((Object)likeEntity);
        return likeEntity;
    }

    @Override
    public void removeLike(ContentEntityObject contentEntity, ConfluenceUser user) {
        Session session = this.sessionFactory.getCurrentSession();
        session.createQuery("from LikeEntity l where l.content.id = :contentId and l.user = :user", LikeEntity.class).setParameter("contentId", (Object)contentEntity.getId()).setParameter("user", (Object)user).list().forEach(arg_0 -> ((Session)session).delete(arg_0));
    }

    @Override
    public void removeAllLikesOn(ContentEntityObject contentEntity) {
        Session session = this.sessionFactory.getCurrentSession();
        session.createQuery("from LikeEntity l where l.content.id = :contentId", LikeEntity.class).setParameter("contentId", (Object)contentEntity.getId()).list().forEach(arg_0 -> ((Session)session).delete(arg_0));
    }

    @Override
    public void removeAllLikesFor(@NonNull ConfluenceUser user) {
        Session session = this.sessionFactory.getCurrentSession();
        session.createQuery("from LikeEntity l where l.user = :user", LikeEntity.class).setParameter("user", (Object)user).list().forEach(arg_0 -> ((Session)session).delete(arg_0));
    }

    @Override
    public boolean hasLike(ContentEntityObject contentEntity, ConfluenceUser user) {
        Query query = this.sessionFactory.getCurrentSession().createQuery("select count(l) from LikeEntity l where l.content.id = :contentId and l.user = :user");
        query.setParameter("contentId", (Object)contentEntity.getId());
        query.setParameter("user", (Object)user);
        return DataAccessUtils.intResult((Collection)query.list()) > 0;
    }

    @Override
    public List<LikeEntity> getLikeEntities(Collection<? extends ContentEntityObject> contentEntities) {
        Objects.requireNonNull(contentEntities);
        if (contentEntities.isEmpty()) {
            return Collections.emptyList();
        }
        Query query = this.sessionFactory.getCurrentSession().createQuery("from LikeEntity l where l.content.id in (:contentEntities) order by l.creationDate desc", LikeEntity.class);
        query.setParameterList("contentEntities", Collections2.transform(contentEntities, Searchable::getId));
        return query.list();
    }

    @Override
    public int countLikes(Searchable searchable) {
        Query query = this.sessionFactory.getCurrentSession().createQuery("select count(l) from LikeEntity l where l.content.id = :contentId");
        query.setParameter("contentId", (Object)searchable.getId());
        return DataAccessUtils.intResult((Collection)query.list());
    }

    @Override
    public Map<Searchable, Integer> countLikes(Collection<? extends Searchable> searchables) {
        if (searchables.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Long, Searchable> idToSearchableMap = new HashMap<Long, Searchable>();
        HashMap<Searchable, Integer> results = new HashMap<Searchable, Integer>();
        for (Searchable searchable : searchables) {
            idToSearchableMap.put(searchable.getId(), searchable);
            results.put(searchable, 0);
        }
        Query query = this.sessionFactory.getCurrentSession().createQuery("select content.id, count(l) from LikeEntity l join l.content as content where l.content.id in (:contentEntities) group by content.id");
        query.setParameterList("contentEntities", Collections2.transform(searchables, Searchable::getId));
        List list = query.list();
        for (Object[] result : list) {
            int numberOfLikes = ((Number)result[1]).intValue();
            Long contentId = (Long)result[0];
            results.put((Searchable)idToSearchableMap.get(contentId), numberOfLikes);
        }
        return ImmutableMap.copyOf(results);
    }
}

