/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.logging;

import jakarta.servlet.ServletException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import org.apache.velocity.exception.MethodInvocationException;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ConfluenceStackTraceRenderer {
    private ConfluenceStackTraceRenderer() {
    }

    public static CharSequence renderStackTrace(Throwable t) {
        StringWriter writer = new StringWriter();
        PrintWriter stackTrace = new PrintWriter(writer);
        t.printStackTrace(stackTrace);
        while (t != null) {
            if ((t = ConfluenceStackTraceRenderer.getNonCauseUnderlying(t)) == null) continue;
            stackTrace.print("Caused by: ");
            t.printStackTrace(stackTrace);
        }
        return writer.getBuffer();
    }

    public static @Nullable Throwable getNonCauseUnderlying(Throwable t) {
        while (t != null && t.getCause() != null) {
            t = t.getCause();
        }
        if (t != null) {
            t = t instanceof InvocationTargetException ? ((InvocationTargetException)t).getTargetException() : (t instanceof MethodInvocationException ? ((MethodInvocationException)t).getWrappedThrowable() : (t instanceof ServletException ? ((ServletException)t).getRootCause() : (t instanceof SQLException ? ((SQLException)t).getNextException() : null)));
        }
        return t;
    }
}

