/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.logging;

import com.atlassian.confluence.util.logging.LoggingContext;
import com.atlassian.json.marshal.Jsonable;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;

public final class LoggingContextRenderer {
    public static final String CONTEXT_LEADER = " -- ";
    public static final String MDC_ENTRY_SEPARATOR = " | ";
    public static final String MDC_KEY_VALUE_SEPARATOR = ": ";

    private LoggingContextRenderer() {
    }

    public static CharSequence renderLoggingContext() {
        if (LoggingContext.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(CONTEXT_LEADER);
        Map context = LoggingContext.getContext();
        Iterator entryIterator = context.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry entry = entryIterator.next();
            Object entryValue = entry.getValue();
            if (entryValue instanceof Jsonable) {
                StringWriter stringWriter = new StringWriter();
                try {
                    ((Jsonable)entryValue).write((Writer)stringWriter);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                buffer.append((String)entry.getKey()).append(MDC_KEY_VALUE_SEPARATOR).append(stringWriter);
            } else {
                buffer.append((String)entry.getKey()).append(MDC_KEY_VALUE_SEPARATOR).append(entryValue);
            }
            if (!entryIterator.hasNext()) continue;
            buffer.append(MDC_ENTRY_SEPARATOR);
        }
        buffer.append(System.lineSeparator());
        return buffer;
    }

    public static CharSequence renderLoggingContextTraceId() {
        if (LoggingContext.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(MDC_ENTRY_SEPARATOR);
        String traceId = LoggingContext.getTraceId();
        if (traceId == null) {
            return "";
        }
        buffer.append("traceId").append(MDC_KEY_VALUE_SEPARATOR).append(traceId);
        buffer.append(System.lineSeparator());
        return buffer;
    }
}

