/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.macro.metadata;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.cache.CoreCache;
import com.atlassian.confluence.impl.macro.metadata.AllMacroMetadataProvider;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.browser.MacroMetadataSource;
import com.atlassian.confluence.macro.browser.beans.MacroMetadata;
import com.atlassian.confluence.server.ApplicationState;
import com.atlassian.confluence.server.ApplicationStatusService;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.predicate.ModuleDescriptorPredicate;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;

public class AllMacroMetadataCache<T extends ModuleDescriptor<Macro> & MacroMetadataSource>
implements AllMacroMetadataProvider<T> {
    private final Cache<Class<? extends MacroMetadataSource>, Map<String, MacroMetadata>> cache;
    private final EventListenerRegistrar eventListenerRegistrar;
    private final ApplicationStatusService applicationStatusService;
    private final AllMacroMetadataProvider<T> allMacroMetadataProvider;

    public AllMacroMetadataCache(CacheFactory cacheFactory, AllMacroMetadataProvider<T> allMacroMetadataProvider, EventListenerRegistrar eventListenerRegistrar, ApplicationStatusService applicationStatusService) {
        this.allMacroMetadataProvider = Objects.requireNonNull(allMacroMetadataProvider);
        this.cache = CoreCache.MACRO_METADATA.getCache(cacheFactory);
        this.eventListenerRegistrar = Objects.requireNonNull(eventListenerRegistrar);
        this.applicationStatusService = applicationStatusService;
    }

    @PostConstruct
    public void registerForEvents() {
        this.eventListenerRegistrar.register((Object)this);
    }

    @PreDestroy
    public void unregisterForEvents() {
        this.eventListenerRegistrar.unregister((Object)this);
    }

    @Override
    public @NonNull Map<String, MacroMetadata> apply(Class<T> descriptorClass, ModuleDescriptorPredicate<Macro> descriptorPredicate) {
        return (Map)this.cache.get(descriptorClass, () -> (Map)this.allMacroMetadataProvider.apply(descriptorClass, descriptorPredicate));
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        this.flushCacheForPluginModule(event.getModule());
    }

    @PluginEventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        this.flushCacheForPluginModule(event.getModule());
    }

    private void flushCacheForPluginModule(ModuleDescriptor<?> moduleDescriptor) {
        if (this.applicationStatusService.getState() != ApplicationState.STOPPING) {
            this.cache.getKeys().stream().filter(moduleDescriptorClass -> moduleDescriptorClass.isInstance(moduleDescriptor)).findAny().ifPresent(arg_0 -> this.cache.remove(arg_0));
        }
    }
}

