/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.metrics;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeExecution;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.event.events.lifecycle.ApplicationStartedEvent;
import com.atlassian.confluence.event.events.monitoring.JmxConfigChangedEvent;
import com.atlassian.confluence.impl.metrics.ConfluenceJmxConfig;
import com.atlassian.confluence.impl.metrics.MicrometerFactoryBean;
import com.atlassian.confluence.impl.profiling.CollectNodeJmxMonitoringConfigs;
import com.atlassian.confluence.impl.profiling.NodeJmxMonitoringConfig;
import com.atlassian.confluence.jmx.JmxConfigService;
import com.atlassian.confluence.setup.settings.DarkFeaturesManager;
import com.atlassian.confluence.setup.settings.UnknownFeatureException;
import com.atlassian.diagnostics.ipd.api.registry.IpdRegistry;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.jmx.JmxMeterRegistry;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceJmxConfigService
implements JmxConfigService {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceJmxConfigService.class);
    private static final String JMX_CONFIG_NAMESPACE = ConfluenceJmxConfigService.class.getName();
    @VisibleForTesting
    static final String JMX_CONFIG_KEY = "jmx.enabled.state";
    private final PluginSettings jmxPluginSettings;
    private final CompositeMeterRegistry compositeMeterRegistry;
    private final ConfluenceJmxConfig confluenceJmxConfig;
    private final EventPublisher eventPublisher;
    private final DarkFeaturesManager darkFeaturesManager;
    private final ClusterManager clusterManager;
    private final IpdRegistry ipdRegistry;

    public ConfluenceJmxConfigService(EventPublisher eventPublisher, ConfluenceJmxConfig confluenceJmxConfig, CompositeMeterRegistry compositeMeterRegistry, PluginSettingsFactory pluginSettingsFactory, DarkFeaturesManager darkFeaturesManager, ClusterManager clusterManager, IpdRegistry ipdRegistry) {
        this.eventPublisher = eventPublisher;
        this.confluenceJmxConfig = confluenceJmxConfig;
        this.compositeMeterRegistry = compositeMeterRegistry;
        this.jmxPluginSettings = pluginSettingsFactory.createSettingsForKey(JMX_CONFIG_NAMESPACE);
        this.darkFeaturesManager = darkFeaturesManager;
        this.clusterManager = clusterManager;
        this.ipdRegistry = ipdRegistry;
    }

    @Override
    public boolean isJmxEnabledOnCluster() {
        Object jmxPersistedEnabledState = this.jmxPluginSettings.get(JMX_CONFIG_KEY);
        if (jmxPersistedEnabledState == null) {
            return this.confluenceJmxConfig.isJmxEnabled();
        }
        return Boolean.parseBoolean(String.valueOf(jmxPersistedEnabledState));
    }

    public boolean isAppMonitoringEnabled() {
        return !this.darkFeaturesManager.getSiteDarkFeatures().isFeatureEnabled("com.atlassian.profiling.ita.metrics.deny");
    }

    public boolean isIpdMonitoringEnabled() {
        return !this.darkFeaturesManager.getSiteDarkFeatures().isFeatureEnabled("confluence.in.product.diagnostics.deny");
    }

    public void setIpdMonitoringEnabled(boolean enableIpdMonitoring) {
        try {
            if (enableIpdMonitoring) {
                if (!this.isJmxEnabledOnCluster()) {
                    this.setJmxMonitoringEnabled(true);
                }
                this.darkFeaturesManager.disableSiteFeature("confluence.in.product.diagnostics.deny");
            } else {
                this.darkFeaturesManager.enableSiteFeature("confluence.in.product.diagnostics.deny");
                this.ipdRegistry.unregisterAllDisabledMetrics();
            }
        }
        catch (UnknownFeatureException e) {
            log.error("Could not find feature flag: {}", (Object)"confluence.in.product.diagnostics.deny", (Object)e);
        }
    }

    public void setAppMonitoringEnabled(boolean enableAppMonitoring) {
        try {
            if (enableAppMonitoring) {
                if (!this.isJmxEnabledOnCluster()) {
                    this.setJmxMonitoringEnabled(true);
                }
                this.darkFeaturesManager.disableSiteFeature("com.atlassian.profiling.ita.metrics.deny");
            } else {
                this.darkFeaturesManager.enableSiteFeature("com.atlassian.profiling.ita.metrics.deny");
            }
        }
        catch (UnknownFeatureException e) {
            log.error("Could not find feature flag: {}", (Object)"com.atlassian.profiling.ita.metrics.deny", (Object)e);
        }
    }

    public void setJmxMonitoringEnabled(boolean isJmxEnabled) {
        log.info("Updating JMX enabled state to {}", (Object)isJmxEnabled);
        this.jmxPluginSettings.put(JMX_CONFIG_KEY, (Object)isJmxEnabled);
        if (!isJmxEnabled) {
            this.setAppMonitoringEnabled(false);
            this.setIpdMonitoringEnabled(false);
        }
        JmxConfigChangedEvent jmxConfigChangedEvent = new JmxConfigChangedEvent(this, isJmxEnabled);
        this.eventPublisher.publish((Object)jmxConfigChangedEvent);
        this.handleConfigChangedEvent(jmxConfigChangedEvent);
    }

    public List<ClusterNodeExecution<NodeJmxMonitoringConfig>> getNodesJmxMonitoringConfigs() {
        return this.clusterManager.submitToAllNodes((Callable)new CollectNodeJmxMonitoringConfigs(), "cluster-manager-executor");
    }

    @EventListener
    public void onApplicationStartedEvent(ApplicationStartedEvent ignored) {
        if (this.isJmxDisabledPropertySet()) {
            return;
        }
        Object object = this.jmxPluginSettings.get(JMX_CONFIG_KEY);
        if (object instanceof Boolean) {
            Boolean isJmxEnabled = (Boolean)object;
            this.confluenceJmxConfig.setIsJmxEnabled(isJmxEnabled);
            this.updateJmxRegistry(isJmxEnabled);
        }
    }

    @EventListener
    public void onClusteredJmxConfigChangedEvent(ClusterEventWrapper clusterEvent) {
        if (!(clusterEvent.getEvent() instanceof JmxConfigChangedEvent)) {
            return;
        }
        this.handleConfigChangedEvent((JmxConfigChangedEvent)clusterEvent.getEvent());
    }

    @PostConstruct
    public void postConstruct() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void preDestroy() {
        this.eventPublisher.unregister((Object)this);
    }

    private Optional<MeterRegistry> getJmxMeterRegistry() {
        return this.compositeMeterRegistry.getRegistries().stream().filter(JmxMeterRegistry.class::isInstance).findFirst();
    }

    private void handleConfigChangedEvent(JmxConfigChangedEvent jmxConfigChangedEvent) {
        if (this.isJmxDisabledPropertySet()) {
            log.info("The jmx config won't be updated on this node, since it is configured via system properties.");
            return;
        }
        log.info("The jmx config service received an event that the config has changed to {}", (Object)jmxConfigChangedEvent.getJmxEnabled());
        this.confluenceJmxConfig.setIsJmxEnabled(jmxConfigChangedEvent.getJmxEnabled());
        this.updateJmxRegistry(jmxConfigChangedEvent.getJmxEnabled());
    }

    private boolean isJmxDisabledPropertySet() {
        return System.getProperty("confluence.jmx.disabled") != null;
    }

    private void updateJmxRegistry(boolean newJmxEnabledState) {
        if (newJmxEnabledState) {
            this.addJmxRegistry();
        } else {
            this.removeJmxRegistry();
        }
    }

    private void addJmxRegistry() {
        Optional<MeterRegistry> jmxMeterRegistry = this.getJmxMeterRegistry();
        log.info("Attempting to add JMX registry. The registry state is {}.", (Object)jmxMeterRegistry.isPresent());
        if (jmxMeterRegistry.isEmpty()) {
            this.compositeMeterRegistry.add((MeterRegistry)MicrometerFactoryBean.createJmxRegistry(this.confluenceJmxConfig));
        }
    }

    private void removeJmxRegistry() {
        Optional<MeterRegistry> jmxMeterRegistry = this.getJmxMeterRegistry();
        log.info("Attempting to remove JMX registry. The registry state is {}.", (Object)jmxMeterRegistry.isPresent());
        jmxMeterRegistry.ifPresent(MeterRegistry::close);
        jmxMeterRegistry.ifPresent(arg_0 -> ((CompositeMeterRegistry)this.compositeMeterRegistry).remove(arg_0));
    }
}

