/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.metrics;

import com.atlassian.confluence.impl.hibernate.metrics.ConfluenceHibernateMetrics;
import com.atlassian.confluence.impl.metrics.ConfluenceMicrometer;
import com.atlassian.confluence.impl.metrics.IndexTaskQueueMetricsBinder;
import com.atlassian.confluence.search.IndexTaskQueue;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.instrument.binder.jvm.JvmGcMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.jvm.JvmThreadMetrics;
import io.micrometer.core.instrument.binder.system.ProcessorMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.core.instrument.binder.tomcat.TomcatMetrics;
import jakarta.annotation.PostConstruct;
import java.util.Arrays;
import java.util.Collections;
import java.util.NoSuchElementException;
import javax.management.MBeanServer;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class MicrometerBinderRegistrar
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(MicrometerBinderRegistrar.class);
    private final MeterRegistry meterRegistry;
    private final MBeanServer mBeanServer;
    private ListableBeanFactory beanFactory;

    public MicrometerBinderRegistrar(MeterRegistry meterRegistry, MBeanServer mBeanServer) {
        this.meterRegistry = meterRegistry;
        this.mBeanServer = mBeanServer;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext;
    }

    @PostConstruct
    public void initSystemMetrics() {
        this.bind(new MeterBinder[]{new ProcessorMetrics(), new UptimeMetrics(), new JvmMemoryMetrics(), new JvmGcMetrics(), new JvmThreadMetrics()});
    }

    @PostConstruct
    public void initTomcatMetrics() throws ReflectiveOperationException {
        this.bind(new MeterBinder[]{new TomcatMetricsCreator().instantiateTomcatMetrics()});
    }

    private void initIndexTaskQueueMetrics() {
        this.beanFactory.getBeansOfType(IndexTaskQueue.class, false, false).forEach((name, queue) -> this.bind(new IndexTaskQueueMetricsBinder((IndexTaskQueue<?>)queue, (String)name)));
    }

    @PostConstruct
    void init() {
        this.initIndexTaskQueueMetrics();
        this.bind(new ConfluenceHibernateMetrics(this.getSessionFactory()));
    }

    private void bind(MeterBinder ... binders) {
        if (ConfluenceMicrometer.isMicrometerEnabled()) {
            Arrays.stream(binders).forEach(binder -> {
                log.info("Binding metrics from {}", (Object)binder.getClass().getTypeName());
                try {
                    binder.bindTo(this.meterRegistry);
                }
                catch (RuntimeException ex) {
                    log.error("Error binding metrics from {}", (Object)binder.getClass().getTypeName(), (Object)ex);
                }
            });
        }
    }

    protected abstract SessionFactoryImplementor getSessionFactory();

    class TomcatMetricsCreator {
        TomcatMetricsCreator() {
        }

        private TomcatMetrics instantiateTomcatMetrics() throws ReflectiveOperationException {
            return this.instantiate(TomcatMetrics.class, null, Collections.emptySet(), MicrometerBinderRegistrar.this.mBeanServer);
        }

        private <T> T instantiate(Class<T> clazz, Object ... args) throws ReflectiveOperationException {
            Object instance = Arrays.stream(clazz.getConstructors()).filter(ctor -> ctor.getParameterTypes().length == args.length).findFirst().orElseThrow(() -> new NoSuchElementException("No constructor found on " + String.valueOf(clazz) + " which takes " + args.length + " arguments")).newInstance(args);
            return clazz.cast(instance);
        }
    }
}

