/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.metrics;

import com.atlassian.confluence.impl.metrics.ConfluenceJmxConfig;
import com.atlassian.util.profiling.micrometer.util.QualifiedCompatibleHierarchicalNameMapper;
import com.atlassian.util.profiling.micrometer.util.UnescapedObjectNameFactory;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jmx.ObjectNameFactory;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.core.lang.NonNull;
import io.micrometer.jmx.JmxConfig;
import io.micrometer.jmx.JmxMeterRegistry;
import org.springframework.beans.factory.config.AbstractFactoryBean;

class MicrometerFactoryBean
extends AbstractFactoryBean<MeterRegistry> {
    public static final MeterFilter IGNORE_ANALYTIC_TAGS = MeterFilter.ignoreTags((String[])new String[]{"atl-analytics"});
    private final ConfluenceJmxConfig confluenceJmxConfig;

    MicrometerFactoryBean(ConfluenceJmxConfig confluenceJmxConfig) {
        this.confluenceJmxConfig = confluenceJmxConfig;
    }

    public Class<?> getObjectType() {
        return MeterRegistry.class;
    }

    @NonNull
    protected MeterRegistry createInstance() {
        CompositeMeterRegistry registries = new CompositeMeterRegistry();
        if (this.confluenceJmxConfig.isJmxEnabled()) {
            registries.add((MeterRegistry)MicrometerFactoryBean.createJmxRegistry(this.confluenceJmxConfig));
        }
        return registries;
    }

    static JmxMeterRegistry createJmxRegistry(ConfluenceJmxConfig confluenceJmxConfig) {
        MetricRegistry metricRegistry = new MetricRegistry();
        JmxReporter jmxReporter = JmxReporter.forRegistry((MetricRegistry)metricRegistry).inDomain("com.atlassian.confluence").createsObjectNamesWith((ObjectNameFactory)new UnescapedObjectNameFactory()).build();
        QualifiedCompatibleHierarchicalNameMapper nameMapper = new QualifiedCompatibleHierarchicalNameMapper();
        JmxMeterRegistry micrometerRegistry = new JmxMeterRegistry((JmxConfig)confluenceJmxConfig, Clock.SYSTEM, (HierarchicalNameMapper)nameMapper, metricRegistry, jmxReporter);
        micrometerRegistry.config().namingConvention(NamingConvention.dot).meterFilter(IGNORE_ANALYTIC_TAGS).onMeterRemoved(m -> {
            if (m instanceof LongTaskTimer) {
                for (Statistic statistic : Statistic.values()) {
                    metricRegistry.remove(nameMapper.toHierarchicalName(m.getId().withTag(statistic), micrometerRegistry.config().namingConvention()));
                }
            }
        });
        return micrometerRegistry;
    }
}

