/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.osgi;

import com.atlassian.security.xml.SecureXmlParserFactory;
import jakarta.annotation.PostConstruct;
import jakarta.persistence.spi.PersistenceProvider;
import jakarta.persistence.spi.PersistenceProviderResolver;
import jakarta.persistence.spi.PersistenceProviderResolverHolder;
import java.util.Arrays;
import java.util.List;
import javax.imageio.ImageIO;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class SystemServiceLoaderInitializer {
    private static final Logger log = LoggerFactory.getLogger(SystemServiceLoaderInitializer.class);

    @PostConstruct
    public void loadKnownServiceLoaders() {
        Object[] readerMimeTypes = ImageIO.getReaderMIMETypes();
        Object[] writerMimeTypes = ImageIO.getWriterMIMETypes();
        if (log.isDebugEnabled()) {
            log.debug("ImageIO mime type handlers loaded for reading {} and writing {}", (Object)Arrays.toString(readerMimeTypes), (Object)Arrays.toString(writerMimeTypes));
        }
        try {
            XmlPullParserFactory.newInstance();
        }
        catch (XmlPullParserException e) {
            log.error("Unable to initialize secure XmlPullParserFactory", (Throwable)e);
        }
        try {
            SecureXmlParserFactory.createSAXParserFactory();
            SecureXmlParserFactory.newDocumentBuilderFactory();
            SecureXmlParserFactory.newXmlInputFactory();
        }
        catch (ParserConfigurationException | SAXException e) {
            log.error("Unable to initialize secure SAXParserFactory", (Throwable)e);
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (TransformerConfigurationException e) {
            log.error("Unable to initialize secure TransformerFactory", (Throwable)e);
        }
        PersistenceProviderResolverHolder.setPersistenceProviderResolver((PersistenceProviderResolver)new PersistenceProviderResolver(this){
            private List<PersistenceProvider> persistenceProviders = PersistenceProviderResolverHolder.getPersistenceProviderResolver().getPersistenceProviders();

            public List<PersistenceProvider> getPersistenceProviders() {
                return this.persistenceProviders;
            }

            public void clearCachedProviders() {
            }
        });
    }
}

