/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.pages.actions;

import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.UploadedResource;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.struts.StrutsHelper;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.struts.multipart.AtlassianJakartaMultiPartRequest;
import com.atlassian.struts.multipart.FileUploadException;
import com.atlassian.struts.multipart.UploadedFile;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachmentUploadHelper {
    private static final Logger log = LoggerFactory.getLogger(AttachmentUploadHelper.class);
    private final AtlassianJakartaMultiPartRequest multiPartRequest;
    private final int maxAttachments;
    private final ConfluenceActionSupport action;
    private final FileUploadManager fileUploadManager;
    private final AttachmentManager attachmentManager;
    private final StrutsHelper strutsHelper;
    private final List<UploadedFile> uploadedFiles;
    private final Set<String> errors = new HashSet<String>();
    private final Map<String, String> filenameToCommentMap = new HashMap<String, String>();
    private final List<String> filenamesSuccessfullyAttached = new ArrayList<String>();

    public AttachmentUploadHelper(AtlassianJakartaMultiPartRequest multiPartRequest, int maxAttachments, ConfluenceActionSupport action, FileUploadManager fileUploadManager, AttachmentManager attachmentManager, StrutsHelper strutsHelper) {
        this.multiPartRequest = multiPartRequest;
        this.maxAttachments = maxAttachments;
        this.action = action;
        this.fileUploadManager = fileUploadManager;
        this.attachmentManager = attachmentManager;
        this.strutsHelper = strutsHelper;
        this.uploadedFiles = this.initUploadedFiles();
    }

    public List<UploadedFile> getUploadedFilesList() {
        return this.uploadedFiles;
    }

    private List<UploadedFile> initUploadedFiles() {
        try {
            return new ArrayList<UploadedFile>(this.strutsHelper.getUploadedFiles((HttpServletRequest)this.multiPartRequest));
        }
        catch (FileUploadException e) {
            this.errors.addAll(this.strutsHelper.localizeStrutsMessages(e.getErrorMsgs()));
            return Collections.emptyList();
        }
    }

    public void validateAttachments() {
        for (int i = 0; i < this.maxAttachments; ++i) {
            String[] fileNames = this.multiPartRequest.getFileNames("file_" + i);
            if (fileNames == null || fileNames.length == 0) continue;
            String fileName = fileNames[0];
            Collection<String> fileValidationErrors = this.verifyFile(fileName);
            if (!fileValidationErrors.isEmpty()) {
                this.removeUploadedFile(fileName);
            }
            this.errors.addAll(fileValidationErrors);
            String comment = this.multiPartRequest.getParameter("comment_" + i);
            if (StringUtils.isNotEmpty((CharSequence)comment) && comment.length() > 255) {
                this.errors.add(this.makeEscapedFileNameError(fileName, "attachment.comment.too.long"));
                this.removeUploadedFile(fileName);
                continue;
            }
            this.filenameToCommentMap.put(fileName, comment);
        }
    }

    public List<Attachment> attachFiles(ContentEntityObject contentEntityObject) {
        ArrayList<Attachment> attachmentsAdded = new ArrayList<Attachment>();
        ArrayList<AttachmentResource> uploadedResources = new ArrayList<AttachmentResource>();
        ArrayList<String> uploadedFilenames = new ArrayList<String>();
        for (UploadedFile uploadedFile : this.uploadedFiles) {
            String fileName = uploadedFile.getFileName();
            uploadedFilenames.add(fileName);
            uploadedResources.add(new UploadedResource(uploadedFile, this.filenameToCommentMap.get(fileName)));
        }
        this.fileUploadManager.storeResources(uploadedResources, contentEntityObject);
        for (String uploadedFilename : uploadedFilenames) {
            Attachment attachment = this.attachmentManager.getAttachment(contentEntityObject, uploadedFilename);
            attachmentsAdded.add(attachment);
            this.filenamesSuccessfullyAttached.add(attachment.getFileName());
        }
        return attachmentsAdded;
    }

    public void processMultipartRequest() {
        String fileParameterName;
        String theFileName;
        Enumeration fileParameterNames;
        if (this.multiPartRequest.hasErrors()) {
            this.action.addActionError(this.action.getText("multipart.request.error"));
            log.warn("An error occurred uploading a file to the server.");
        }
        if (!(fileParameterNames = this.multiPartRequest.getFileParameterNames()).hasMoreElements()) {
            this.action.addActionError(this.action.getText("null.file.error"));
        }
        if (this.action.getActionErrors().isEmpty() && (theFileName = this.multiPartRequest.getFileNames(fileParameterName = StringUtils.defaultString((String)((String)fileParameterNames.nextElement())))[0]) == null) {
            this.action.addActionError(this.action.getText("null.file.error"));
        }
    }

    public List<String> getFilenamesSuccessfullyAttached() {
        return this.filenamesSuccessfullyAttached;
    }

    public Collection<String> getErrors() {
        return Collections.unmodifiableSet(this.errors);
    }

    private Collection<String> verifyFile(String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            return List.of(this.action.getText("fileName.required"));
        }
        for (UploadedFile uploadedFile : this.uploadedFiles) {
            log.debug("fileName={}, uploadedFile.getFileName()={}", (Object)fileName, (Object)uploadedFile.getFileName());
            if (!fileName.equals(uploadedFile.getFileName())) continue;
            return List.of();
        }
        return List.of(this.makeEscapedFileNameError(fileName, "fileName.does.not.match.uploaded.file"));
    }

    private String makeEscapedFileNameError(String fileName, String messageKey) {
        return this.action.getText(messageKey, new String[]{HtmlUtil.htmlEncode(fileName)});
    }

    private void removeUploadedFile(String filename) {
        this.uploadedFiles.removeIf(uploadedFile -> StringUtils.equals((CharSequence)filename, (CharSequence)uploadedFile.getFileName()));
    }
}

