/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.pages.persistence.dao;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.confluence.cache.CoreCache;
import com.atlassian.confluence.impl.cache.ReadThroughAtlassianCache;
import com.atlassian.confluence.impl.cache.ReadThroughCache;
import com.atlassian.confluence.impl.pages.persistence.dao.PageDaoCachingAspect;
import com.atlassian.confluence.internal.pages.persistence.PageDaoInternal;
import com.atlassian.confluence.internal.persistence.ContentEntityObjectDaoInternal;
import com.atlassian.confluence.pages.Page;
import java.util.function.Consumer;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.aop.AfterReturningAdvice;
import org.springframework.aop.aspectj.annotation.AspectJProxyFactory;
import org.springframework.aop.support.NameMatchMethodPointcutAdvisor;

final class CachingPageDaoFactory {
    private final ReadThroughCache<String, Long> pageIdCache;

    public CachingPageDaoFactory(CacheFactory cacheFactory) {
        this(CoreCache.PAGE_ID_BY_SPACE_KEY_AND_TITLE.getCache(cacheFactory));
    }

    CachingPageDaoFactory(Cache<String, Long> cache) {
        this.pageIdCache = new ReadThroughAtlassianCache<String, Long>(cache);
    }

    public PageDaoInternal decorate(PageDaoInternal delegate) {
        return this.getContentEntityObjectDao(delegate, PageDaoInternal.class, proxyFactory -> proxyFactory.addAspect((Object)new PageDaoCachingAspect(delegate, this.pageIdCache)));
    }

    public ContentEntityObjectDaoInternal decorate(ContentEntityObjectDaoInternal delegate) {
        return this.getContentEntityObjectDao(delegate, ContentEntityObjectDaoInternal.class, proxyFactory -> proxyFactory.addAdvisor(this.createCacheClearAdvisor()));
    }

    private <T> T getContentEntityObjectDao(T delegate, Class<T> type, Consumer<AspectJProxyFactory> config) {
        AspectJProxyFactory proxyFactory = new AspectJProxyFactory();
        proxyFactory.setTarget(delegate);
        proxyFactory.setInterfaces(new Class[]{type});
        config.accept(proxyFactory);
        return (T)proxyFactory.getProxy();
    }

    private Advisor createCacheClearAdvisor() {
        NameMatchMethodPointcutAdvisor advisor = new NameMatchMethodPointcutAdvisor();
        advisor.setMappedNames(new String[]{"remove", "removeEntity", "save", "saveEntity", "saveRaw"});
        advisor.setAdvice((Advice)((AfterReturningAdvice)(returnValue, method, args, target) -> {
            Object entity = args[0];
            if (entity instanceof Page) {
                this.pageIdCache.remove(CachingPageDaoFactory.cacheKey((Page)entity));
            }
        }));
        return advisor;
    }

    static String cacheKey(String spaceKey, String title) {
        return spaceKey + "-" + title;
    }

    static String cacheKey(Page page) {
        return CachingPageDaoFactory.cacheKey(page.getSpaceKey(), page.getTitle());
    }
}

