/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.pages.persistence.dao;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.HibernateObjectDao;
import com.atlassian.confluence.impl.pages.persistence.dao.DraftDao;
import com.atlassian.confluence.impl.search.IndexerEventListener;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.util.Assert;

public class HibernateDraftDao
extends HibernateObjectDao<Draft>
implements DraftDao {
    private static final Logger log = LoggerFactory.getLogger(HibernateDraftDao.class);
    private EventPublisher eventPublisher;

    public HibernateDraftDao(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public Class<Draft> getPersistentClass() {
        return Draft.class;
    }

    @Override
    protected Draft getByClassId(long id) {
        ContentEntityObject ceo = this.hibernate().execute(session -> (ContentEntityObject)session.get(ContentEntityObject.class, (Serializable)Long.valueOf(id)));
        if (!(ceo instanceof Draft)) {
            return null;
        }
        return (Draft)ceo;
    }

    @Override
    public void saveOrUpdate(Draft draft) throws IllegalArgumentException {
        Assert.notNull((Object)draft, (String)"Draft should not be null");
        Assert.hasText((String)draft.getPageId(), (String)("Draft content ID should be provided, " + String.valueOf(draft)));
        Assert.notNull((Object)draft.getCreator(), (String)("Draft creator name should be provided, " + String.valueOf(draft)));
        Assert.hasText((String)draft.getDraftType(), (String)("Draft type should be provided, " + String.valueOf(draft)));
        Draft persistentDraft = null;
        if (!draft.isNewPage()) {
            persistentDraft = this.getDraft(draft.getPageId(), draft.getCreator(), draft.getDraftType(), draft.getDraftSpaceKey());
        }
        if (persistentDraft == null) {
            this.save(draft);
        } else {
            this.updateModificationData(draft);
            BeanUtils.copyProperties((Object)draft, (Object)persistentDraft, (String[])new String[]{"id", "content", "creatorName", "lastModifierName"});
        }
    }

    @Override
    public Draft getDraft(String pageId, ConfluenceUser creator, String draftType, String spaceKey) {
        if (StringUtils.isBlank((CharSequence)pageId) || creator == null || StringUtils.isBlank((CharSequence)draftType)) {
            log.warn("Could not retrieve draft with invalid draft parameters, pageId: [{}], creator: [{}], draftType: [{}]", new Object[]{pageId, creator, draftType});
            return null;
        }
        List results = Draft.NEW.equals(pageId) ? this.findNamedQueryStringParams("confluence.draft_findByPageIdAndCreatorSpacekey", "pageId", pageId, "creator", (Object)creator, "draftType", (Object)draftType, "draftSpaceKey", (Object)spaceKey, HibernateObjectDao.Cacheability.CACHEABLE, 2) : this.findNamedQueryStringParams("confluence.draft_findByPageIdAndCreator", "pageId", (Object)pageId, "creator", (Object)creator, "draftType", (Object)draftType, HibernateObjectDao.Cacheability.CACHEABLE, 2);
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            log.warn("Found {} drafts for pageId = {} creator = '{}' draftType = '{}'", new Object[]{results.size(), pageId, creator, draftType});
        }
        return (Draft)results.get(0);
    }

    @Override
    public Draft getDraft(long draftId) {
        return this.getByClassId(draftId);
    }

    @Override
    public void remove(Draft draft) {
        if (!draft.isPersistent()) {
            throw new IllegalArgumentException("Attempt to remove a draft that is not persisted: " + String.valueOf(draft));
        }
        Draft persistentDraft = this.getDraft(draft.getId());
        if (persistentDraft != null) {
            this.hibernate().delete(persistentDraft);
            this.unIndex(persistentDraft);
        }
    }

    private void unIndex(Draft draft) {
        this.publishEvent((indexer, changeIndexer) -> indexer.unIndexIncludingDependents(draft));
    }

    @Override
    public List<Draft> findByCreator(ConfluenceUser creator) {
        if (creator == null) {
            return Collections.emptyList();
        }
        return this.findNamedQueryStringParam("confluence.draft_findByCreator", "creator", creator, HibernateObjectDao.Cacheability.CACHEABLE);
    }

    @Override
    public int countDrafts(ConfluenceUser creator) {
        if (creator == null) {
            return 0;
        }
        return DataAccessUtils.intResult((Collection)this.findNamedQueryStringParam("confluence.draft_countDraftsForCreator", "creator", creator));
    }

    @Override
    public List<Draft> findAll() {
        return this.getSessionFactory().getCurrentSession().createQuery("from Draft", Draft.class).list();
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        Preconditions.checkState((boolean)Searchable.class.isAssignableFrom(this.getPersistentClass()), (Object)("EventPublisher is not required for entity " + String.valueOf(this.getPersistentClass())));
        this.eventPublisher = eventPublisher;
    }

    @Override
    protected void publishEvent(IndexerEventListener.VisitorEvent event) {
        this.eventPublisher.publish((Object)event);
    }
}

