/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.pages.persistence.dao;

import com.atlassian.confluence.impl.cache.ReadThroughCache;
import com.atlassian.confluence.impl.cache.ReadThroughEntityCache;
import com.atlassian.confluence.impl.pages.persistence.dao.CachingPageDaoFactory;
import com.atlassian.confluence.internal.pages.persistence.PageDaoInternal;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.checkerframework.checker.nullness.qual.Nullable;

@Aspect
final class PageDaoCachingAspect {
    private final PageDaoInternal delegate;
    private final ReadThroughCache<String, Long> pageIdCache;

    PageDaoCachingAspect(PageDaoInternal delegate, ReadThroughCache<String, Long> pageIdCache) {
        this.delegate = delegate;
        this.pageIdCache = pageIdCache;
    }

    @Around(value="execution(com.atlassian.confluence.pages.Page com.atlassian.confluence.pages.persistence.dao.PageDao.getPage(..)) && args(space, pageTitle)", argNames="ignored,space,pageTitle")
    Page getPage(ProceedingJoinPoint ignored, Space space, String pageTitle) {
        return this.loadPage(space, pageTitle, this.delegate::getPage, this.delegate::getPageById);
    }

    @Around(value="execution(com.atlassian.confluence.pages.Page com.atlassian.confluence.pages.persistence.dao.PageDao.getPageWithComments(..)) && args(space, pageTitle)", argNames="ignored,space,pageTitle")
    Page getPageWithComments(ProceedingJoinPoint ignored, Space space, String pageTitle) {
        return this.loadPage(space, pageTitle, this.delegate::getPageWithComments, this.delegate::getPageByIdWithComments);
    }

    private Page loadPage(@Nullable Space space, String pageTitle, BiFunction<Space, String, Page> getBySpaceAndTitle, Function<Long, Page> getById) {
        if (space == null) {
            return null;
        }
        String cacheKey = CachingPageDaoFactory.cacheKey(space.getKey(), pageTitle);
        Predicate<Page> pageTester = page -> page.isCurrent() && page.getTitle().equals(pageTitle) && page.getSpaceKey().equals(space.getKey());
        return ReadThroughEntityCache.forConfluenceEntityObjects(this.pageIdCache, getById).get(cacheKey, () -> (Page)getBySpaceAndTitle.apply(space, pageTitle), pageTester);
    }
}

