/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.pages.readtime;

import com.atlassian.confluence.impl.pages.readtime.EstimatedReadTimeService;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEstimatedReadTimeService
implements EstimatedReadTimeService {
    private static final Logger log = LoggerFactory.getLogger(DefaultEstimatedReadTimeService.class);
    private static final int SECONDS_IN_MIN = 60;
    private static final String AC_IMAGE_TAG = "<ac:image";
    protected static final int WORDS_PER_MINUTE = 265;

    @Override
    public int getReadTime(String xhtmlContent) {
        int readTime = 1;
        if (xhtmlContent == null) {
            return readTime;
        }
        try {
            int wordReadTimeInSecs = this.getWordReadTimeInSecs(xhtmlContent);
            int imageReadTimeInSecs = this.getImageReadTimeInSecs(xhtmlContent);
            readTime = (int)Math.ceil((double)(wordReadTimeInSecs + imageReadTimeInSecs) / 60.0);
            return readTime == 0 ? 1 : readTime;
        }
        catch (Exception e) {
            log.error("Error in calculating read time for xhtmlContent: {}", (Object)xhtmlContent, (Object)e);
            return readTime;
        }
    }

    private int getWordReadTimeInSecs(String xhtmlContent) {
        String cleanedText = Jsoup.parse((String)xhtmlContent).text();
        int wordCount = new StringTokenizer(cleanedText).countTokens();
        int wordReadTimeInSecs = (int)Math.ceil((double)(wordCount * 60) / 265.0);
        log.debug("wordCount: {}, wordCountTimeInSecs: {}", (Object)wordCount, (Object)wordReadTimeInSecs);
        return wordReadTimeInSecs;
    }

    private int getImageReadTimeInSecs(String xhtmlContent) {
        int imageCount = StringUtils.countMatches((CharSequence)xhtmlContent, (CharSequence)AC_IMAGE_TAG);
        return this.getImageTime(imageCount);
    }

    private int getImageTime(int imageCount) {
        int imageTimeInSecs = 0;
        for (int i = 0; i < imageCount; ++i) {
            imageTimeInSecs += Math.max(12 - i, 3);
        }
        log.debug("imageCount: {}, imageTimeInSecs: {} ", (Object)imageCount, (Object)imageTimeInSecs);
        return imageTimeInSecs;
    }
}

