/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.pages.thumbnail;

import com.atlassian.confluence.pages.Attachment;
import com.atlassian.core.util.thumbnail.ThumbnailUtil;
import com.atlassian.renderer.util.FileTypeUtil;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttachmentThumbnailValidator {
    private static final Logger log = LoggerFactory.getLogger(AttachmentThumbnailValidator.class);

    public static boolean isThumbnailable(@Nullable Attachment attachment) {
        if (attachment != null) {
            String contentType = FileTypeUtil.getContentType((String)attachment.getFileName());
            if (log.isDebugEnabled()) {
                log.debug("Attachment {}. Content type {} is thumbnailable: {}. Media type {} is thumbnailable: {}. Attachment is thumbnailable: {}.", new Object[]{attachment.getDisplayTitle(), contentType, AttachmentThumbnailValidator.isThumbnailable(contentType), attachment.getMediaType(), AttachmentThumbnailValidator.isThumbnailable(attachment.getMediaType()), AttachmentThumbnailValidator.isThumbnailable(contentType) || AttachmentThumbnailValidator.isThumbnailable(attachment.getMediaType())});
            }
            return AttachmentThumbnailValidator.isThumbnailable(contentType) || AttachmentThumbnailValidator.isThumbnailable(attachment.getMediaType());
        }
        log.debug("Cannot create thumbnail. Attachment is null.");
        return false;
    }

    public static boolean isThumbnailable(String mimeType) {
        log.debug("Mime type is {}", (Object)mimeType);
        if (AttachmentThumbnailValidator.isImageFormatNotSupported(mimeType)) {
            log.debug("Mime type matched. {} is NOT supported for thumbnails.", (Object)mimeType);
            return false;
        }
        if (ThumbnailUtil.isMimeTypeSupported((String)mimeType)) {
            log.debug("Mime type matched. {} is thumbnailable.", (Object)mimeType);
            return true;
        }
        log.debug("Mime type {} not matched. Will be thumbnailable only if mime type equals image/pjpeg: {}", (Object)mimeType, (Object)StringUtils.equalsIgnoreCase((CharSequence)mimeType, (CharSequence)"image/pjpeg"));
        return StringUtils.equalsIgnoreCase((CharSequence)mimeType, (CharSequence)"image/pjpeg");
    }

    private static boolean isImageFormatNotSupported(String mimeType) {
        FileFormat fileFormat = FileFormat.fromMimeType(mimeType);
        return fileFormat == FileFormat.PSD && !AttachmentThumbnailValidator.isPsdEnabled() || fileFormat == FileFormat.TIF && !AttachmentThumbnailValidator.isTifEnabled();
    }

    private static boolean isTifEnabled() {
        return Boolean.getBoolean("confluence.document.conversion.imaging.enabled.tif");
    }

    private static boolean isPsdEnabled() {
        return Boolean.getBoolean("confluence.document.conversion.imaging.enabled.psd");
    }

    static enum FileFormat {
        PSD(new String[]{"image/photoshop", "image/x-photoshop", "image/psd", "application/photoshop", "application/psd", "zz-application/zz-winassoc-psd"}),
        TIF(new String[]{"image/tif", "image/x-tif", "image/tiff", "image/x-tiff", "application/tif", "application/x-tif", "application/tiff", "application/x-tiff"});

        private final String[] mimeTypes;

        private FileFormat(String[] mimeTypes) {
            this.mimeTypes = mimeTypes;
        }

        public static FileFormat fromMimeType(String mimeType) {
            if (mimeType == null) {
                return null;
            }
            String newMimeType = mimeType.trim().toLowerCase();
            for (FileFormat fileFormat : FileFormat.values()) {
                String[] mimeTypes;
                for (String entry : mimeTypes = fileFormat.mimeTypes) {
                    if (!entry.equals(newMimeType)) continue;
                    return fileFormat;
                }
            }
            return null;
        }
    }
}

