/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.pagination;

import com.atlassian.confluence.impl.pagination.PaginationQuery;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public class PaginationQueryImpl<F, T>
implements PaginationQuery<F, T> {
    private final List<Predicate<F>> predicates = new ArrayList<Predicate<F>>();
    private Function<F, T> modelConverter;

    @Override
    public PaginationQuery<F, T> createWithPredicate(Predicate<F> predicate) {
        this.predicates.add(predicate);
        return this;
    }

    @Override
    public PaginationQuery<F, T> createWithModelConverter(Function<F, T> modelConverter) {
        this.modelConverter = modelConverter;
        return this;
    }

    @Override
    public List<Predicate<F>> predicates() {
        return ImmutableList.copyOf(this.predicates);
    }

    @Override
    public Function<F, T> modelConverter() {
        return this.modelConverter;
    }

    public static <F, T> PaginationQuery<F, T> newQuery() {
        return new PaginationQueryImpl<F, T>();
    }

    public static <F, T> PaginationQuery<F, T> newQuery(Function<F, T> modelConverter) {
        return new PaginationQueryImpl<F, T>().createWithModelConverter(modelConverter);
    }

    public static <F, T> PaginationQuery<F, T> createNewQuery(Function<F, T> modelConverter) {
        return PaginationQueryImpl.newQuery(modelConverter);
    }

    public static <T> PaginationQuery<T, T> newIdentityQuery() {
        return new PaginationQueryImpl().createWithModelConverter(Function.identity());
    }

    public static <T> PaginationQuery<T, T> newIdentityQuery(Class<T> ignored) {
        return PaginationQueryImpl.newIdentityQuery();
    }
}

