/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.plugin;

import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.event.events.plugin.AsyncPluginFrameworkStartedEvent;
import com.atlassian.confluence.event.events.plugin.PluginDisableEvent;
import com.atlassian.confluence.event.events.plugin.PluginEnableEvent;
import com.atlassian.confluence.event.events.plugin.PluginEvent;
import com.atlassian.confluence.event.events.plugin.PluginFrameworkStartedEvent;
import com.atlassian.confluence.event.events.plugin.PluginInstallEvent;
import com.atlassian.confluence.event.events.plugin.PluginModuleDisableEvent;
import com.atlassian.confluence.event.events.plugin.PluginModuleEnableEvent;
import com.atlassian.confluence.event.events.plugin.PluginModuleEvent;
import com.atlassian.confluence.event.events.plugin.PluginUninstallEvent;
import com.atlassian.confluence.event.events.plugin.StrutsStateChangeEvent;
import com.atlassian.confluence.impl.event.RegisterEventListeners;
import com.atlassian.confluence.plugin.PluginsClassLoaderAvailableEvent;
import com.atlassian.confluence.util.logging.LoggingContext;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginException;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.manager.DefaultPluginManager;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;

@RegisterEventListeners
public class ConfluencePluginManager
extends DefaultPluginManager
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ConfluencePluginManager.class);
    private final AtomicBoolean initialised = new AtomicBoolean(false);
    private final EventPublisher eventPublisher;
    private ApplicationContext applicationContext;
    private final PluginAccessor pluginAccessor;

    protected ConfluencePluginManager(DefaultPluginManager.Builder<? extends DefaultPluginManager.Builder> builder, PluginAccessor pluginAccessor, EventPublisher eventPublisher, PluginInstaller pluginInstaller) {
        super(builder);
        this.pluginAccessor = pluginAccessor;
        this.setPluginInstaller(pluginInstaller);
        this.eventPublisher = eventPublisher;
    }

    public void init() throws PluginParseException, NotificationException {
        if (!this.initialised.compareAndSet(false, true)) {
            log.warn("Init() called on an already initialised plugin manager. Ignoring.");
            return;
        }
        super.init();
    }

    public void earlyStartup() throws PluginParseException, NotificationException {
        ConfluencePluginManager.setSystemPropertyIfNone("atlassian.enable.spring.strong.cache.bean.metadata", "true");
        ConfluencePluginManager.setSystemPropertyIfNone("atlassian.enable.spring.strong.cache.bean.metadata.flush", "true");
        ConfluencePluginManager.setSystemPropertyIfNone("com.atlassian.plugin.shutdown.asynchronously", "false");
        ConfluencePluginManager.setOrAppendToSysProp("atlassian.org.osgi.framework.bootdelegation.extra", ",", "org.apache.xpath", "org.apache.xpath.*", "org.glassfish.jaxb.runtime.v2");
        if (this.applicationContext != null) {
            this.applicationContext.publishEvent((ApplicationEvent)new PluginsClassLoaderAvailableEvent((Object)this, (ClassLoader)this.getClassLoader()));
        }
        super.earlyStartup();
    }

    private static void setOrAppendToSysProp(String name, String delimiter, String ... values) {
        String currentValue = System.getProperty(name);
        if (currentValue == null) {
            System.setProperty(name, String.join((CharSequence)delimiter, values));
        } else {
            System.setProperty(name, currentValue + delimiter + String.join((CharSequence)delimiter, values));
        }
    }

    public void lateStartup() throws PluginParseException, NotificationException {
        int earlyStartupPlugins = this.getEnabledPlugins().size();
        super.lateStartup();
        int lateStartupPlugins = this.getEnabledPlugins().size() - earlyStartupPlugins;
        LoggingContext.executeWithContext((String)"lateStartupPlugins", (Object)lateStartupPlugins, () -> log.info("Enabled {} plugins in lateStartup", (Object)lateStartupPlugins));
        this.eventPublisher.publish((Object)new PluginFrameworkStartedEvent((Object)this));
        this.eventPublisher.publish((Object)new AsyncPluginFrameworkStartedEvent((Object)this));
        if (!this.isSetupPluginManager()) {
            this.eventPublisher.publish((Object)new StrutsStateChangeEvent((Object)this));
        }
    }

    protected boolean isSetupPluginManager() {
        return false;
    }

    @EventListener
    public void onClusterEvent(ClusterEventWrapper event) {
        if (this.isSetupPluginManager()) {
            return;
        }
        log.debug("onApplicationEvent [ {} ]", (Object)event);
        ClusterEvent wrappedEvent = event.getEvent();
        if (!(wrappedEvent instanceof PluginEvent)) {
            return;
        }
        PluginEvent pluginEvent = (PluginEvent)wrappedEvent;
        log.debug("Received cluster plugin event: {}", (Object)pluginEvent);
        if (pluginEvent instanceof PluginModuleEvent) {
            this.processModuleEvent((PluginModuleEvent)pluginEvent);
        } else {
            this.processPluginEvent(pluginEvent);
        }
    }

    private void processModuleEvent(PluginModuleEvent pluginEvent) {
        log.debug("processModuleEvent [ {} ]", (Object)pluginEvent);
        ModuleDescriptor module = this.pluginAccessor.getPluginModule(pluginEvent.getPluginKey());
        if (module == null) {
            log.error("Could not process the event [{}] for plugin key '{}' because the component could not be found.", (Object)pluginEvent, (Object)pluginEvent.getPluginKey());
            return;
        }
        if (pluginEvent instanceof PluginModuleEnableEvent) {
            this.notifyModuleEnabled(module);
            return;
        }
        if (pluginEvent instanceof PluginModuleDisableEvent) {
            this.notifyModuleDisabled(module);
        }
    }

    private void processPluginEvent(PluginEvent pluginEvent) {
        log.debug("processPluginEvent [ {} ]", (Object)pluginEvent);
        if (pluginEvent instanceof PluginInstallEvent) {
            this.processClusteredInstallEvent(pluginEvent);
            return;
        }
        Plugin plugin = this.pluginAccessor.getPlugin(pluginEvent.getPluginKey());
        if (plugin == null) {
            log.error("Could not process the event [{}] for plugin key '{}' because the component could not be found.", (Object)pluginEvent, (Object)pluginEvent.getPluginKey());
            return;
        }
        if (pluginEvent instanceof PluginUninstallEvent) {
            this.processClusteredUninstallEvent(plugin);
            return;
        }
        if (pluginEvent instanceof PluginEnableEvent) {
            this.enablePlugins(new String[]{pluginEvent.getPluginKey()});
            return;
        }
        if (pluginEvent instanceof PluginDisableEvent) {
            this.disablePluginWithoutPersisting(pluginEvent.getPluginKey());
        }
    }

    private void processClusteredUninstallEvent(Plugin plugin) {
        log.info("Received clustered plugin uninstall event for {}", (Object)plugin.getKey());
        try {
            this.disablePluginWithoutPersisting(plugin.getKey());
            this.unloadPlugin(plugin);
        }
        catch (PluginException e) {
            log.error("Error uninstalling plugin: {}", (Object)plugin.getKey(), (Object)e);
        }
    }

    private void processClusteredInstallEvent(PluginEvent pluginEvent) {
        log.info("Received clustered plugin install event for {}", (Object)pluginEvent.getPluginKey());
        try {
            this.scanForNewPlugins();
        }
        catch (PluginParseException ppe) {
            log.error("Error installing plugin from another node:{}", (Object)pluginEvent, (Object)ppe);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private static void setSystemPropertyIfNone(String name, String value) {
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }
}

