/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.plugin;

import com.atlassian.plugin.predicate.PluginKeyPatternsPredicate;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;

@Configuration
class DelayedPluginLoadConfig {
    private static final Logger log = LoggerFactory.getLogger(DelayedPluginLoadConfig.class);
    private static final Set<PluginKeysResource> BUNDLED_PLUGIN_KEY_LISTS = Set.of(new PluginKeysResource("classpath:/META-INF/plugin-keys/confluence-core-xml-plugins.txt"), new PluginKeysResource("/WEB-INF/plugin-keys/confluence-bundled-plugins-external-library.txt"), new PluginKeysResource("/WEB-INF/plugin-keys/confluence-bundled-plugins-library.txt"));
    private static final PluginKeyPatterns ADDITIONAL_EARLY_STARTUP_PATTERNS = new PluginKeyPatterns(new PluginKeyPattern("\\Qcom.atlassian.oauth.atlassian-oauth-api\\E(?:$|-.*)"), new PluginKeyPattern("\\Qcom.atlassian.plugins.atlassian-spring-interceptor-adapter-plugin\\E(?:$|-.*)"), new PluginKeyPattern("\\Qcom.atlassian.confluence.plugins.gadgets.spi\\E"), new PluginKeyPattern("\\Qcom.atlassian.confluence.plugins.gadgets\\E"), new PluginKeyPattern("\\Qcom.atlassian.gadgets.atlassian-gadgets-api\\E"), new PluginKeyPattern("\\Qcom.atlassian.gadgets.atlassian-gadgets-spi\\E"), new PluginKeyPattern("\\Qcom.atlassian.gadgets.oauth.serviceprovider\\E"), new PluginKeyPattern("\\Qcom.atlassian.gadgets.publisher\\E"));
    private static final Set<PluginKey> EARLY_STARTUP_EXCLUSIONS = Set.of(new PluginKey("com.atlassian.migration.agent"), new PluginKey("com.atlassian.confluence.extra.team-calendars"), new PluginKey("com.atlassian.monitoring.and.alerting.atlassian-lighthouse-plugin"));

    DelayedPluginLoadConfig() {
    }

    @Bean
    PluginKeyPatternsPredicate pluginsDelayedLoadPredicate(ResourceLoader resourceLoader) {
        log.info("Loading bundled plugin keys from {}", BUNDLED_PLUGIN_KEY_LISTS);
        log.info("Excluding plugins from early startup: {}", EARLY_STARTUP_EXCLUSIONS);
        return this.getBundledPluginKeys(BUNDLED_PLUGIN_KEY_LISTS, resourceLoader).including(ADDITIONAL_EARLY_STARTUP_PATTERNS).excluding(EARLY_STARTUP_EXCLUSIONS).toPluginKeyPatternsPredicate(PluginKeyPatternsPredicate.MatchType.MATCHES_NONE);
    }

    PluginKeyPatterns getBundledPluginKeys(Collection<PluginKeysResource> bundledPluginKeyLists, ResourceLoader resourceLoader) {
        return bundledPluginKeyLists.stream().flatMap(resource -> resource.read(resourceLoader)).map(PluginKeyPatterns::new).reduce(PluginKeyPatterns::including).orElseThrow();
    }

    record PluginKeyPatterns(Set<PluginKeyPattern> keys) {
        PluginKeyPatterns(PluginKeyPattern ... patterns) {
            this(Set.of(patterns));
        }

        PluginKeyPatterns(PluginKey key) {
            this(Set.of(key.asPattern()));
        }

        PluginKeyPatterns including(PluginKeyPatterns others) {
            LinkedHashSet<PluginKeyPattern> copy = new LinkedHashSet<PluginKeyPattern>(this.keys);
            copy.addAll(others.keys);
            return new PluginKeyPatterns(copy);
        }

        PluginKeyPatterns excluding(Iterable<PluginKey> others) {
            LinkedHashSet<PluginKeyPattern> copy = new LinkedHashSet<PluginKeyPattern>(this.keys);
            others.forEach(key -> copy.remove(key.asPattern()));
            return new PluginKeyPatterns(copy);
        }

        PluginKeyPatternsPredicate toPluginKeyPatternsPredicate(PluginKeyPatternsPredicate.MatchType matchType) {
            return new PluginKeyPatternsPredicate(matchType, (Collection)this.keys.stream().map(PluginKeyPattern::pattern).collect(Collectors.toSet()));
        }
    }

    record PluginKeysResource(String location) {
        @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
        Stream<PluginKey> read(ResourceLoader resourceLoader) {
            Resource resource = resourceLoader.getResource(this.location);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(resource.getInputStream(), StandardCharsets.UTF_8));
                return reader.lines().map(PluginKey::new);
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        }
    }

    record PluginKeyPattern(String pattern) {
    }

    record PluginKey(String val) {
        PluginKeyPattern asPattern() {
            return new PluginKeyPattern("\\Q" + this.val + "\\E");
        }
    }
}

