/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.plugin;

import com.atlassian.confluence.impl.osgi.OsgiServiceRegistry;
import com.atlassian.confluence.impl.osgi.OsgiServiceRegistryImpl;
import com.atlassian.confluence.impl.osgi.SystemServiceLoaderInitializer;
import com.atlassian.confluence.plugin.PluginDirectoryProvider;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.osgi.container.OsgiPersistentCache;
import com.atlassian.plugin.osgi.container.PackageScannerConfiguration;
import com.atlassian.plugin.osgi.container.felix.FelixOsgiContainerManager;
import com.atlassian.plugin.osgi.container.impl.DefaultOsgiPersistentCache;
import com.atlassian.plugin.osgi.hostcomponents.HostComponentProvider;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ContextResource;

@Configuration
class OsgiContainerConfiguration {
    @Resource
    private PackageScannerConfiguration packageScanningConfiguration;
    @Resource
    private HostComponentProvider hostComponentProvider;
    @Resource
    private PluginEventManager pluginEventManager;
    @Resource
    private PluginDirectoryProvider bootstrapPluginDirectoryProvider;
    @Value(value="/WEB-INF/osgi-framework-bundles")
    private ContextResource frameworkBundlesLocation;

    OsgiContainerConfiguration() {
    }

    @Bean(destroyMethod="clearExportCache")
    FelixOsgiContainerManager osgiContainerManager() throws IOException {
        return new FelixOsgiContainerManager(this.frameworkBundlesLocation.getFile(), this.osgiPersistentCache(), this.packageScanningConfiguration, this.hostComponentProvider, this.pluginEventManager);
    }

    @Bean
    OsgiPersistentCache osgiPersistentCache() {
        return new DefaultOsgiPersistentCache(this.bootstrapPluginDirectoryProvider.getPluginsPersistentCacheDirectory());
    }

    @Bean
    OsgiServiceRegistry osgiServiceRegistry() throws IOException {
        return new OsgiServiceRegistryImpl(this.osgiContainerManager());
    }

    @PostConstruct
    void loadKnownServiceLoaders() {
        new SystemServiceLoaderInitializer().loadKnownServiceLoaders();
    }
}

