/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.plugin;

import com.atlassian.bandana.dmz.BandanaManagerInternal;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheManager;
import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.impl.health.HealthCheckRunner;
import com.atlassian.confluence.impl.health.PluginFrameworkStartedHealthCheckListener;
import com.atlassian.confluence.impl.plugin.AutodetectClassPrefixModuleFactory;
import com.atlassian.confluence.impl.plugin.AutodetectModuleFactoryHolder;
import com.atlassian.confluence.impl.plugin.BandanaPluginStateStore;
import com.atlassian.confluence.impl.plugin.CachingPluginPersistentStateStore;
import com.atlassian.confluence.impl.plugin.ConfluenceHostContainer;
import com.atlassian.confluence.impl.plugin.ConfluencePluginManager;
import com.atlassian.confluence.impl.plugin.DefaultPluginInstaller;
import com.atlassian.confluence.impl.plugin.DeprecatedPluginStateStore;
import com.atlassian.confluence.impl.plugin.EventDispatchingPluginController;
import com.atlassian.confluence.impl.plugin.persistence.HibernatePluginDataDao;
import com.atlassian.confluence.impl.plugin.persistence.PluginDataDao;
import com.atlassian.confluence.impl.spring.CachedIntrospectionResultsFlusher;
import com.atlassian.event.api.EventListenerRegistrar;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptorFactory;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginController;
import com.atlassian.plugin.PluginInstaller;
import com.atlassian.plugin.PluginRegistry;
import com.atlassian.plugin.StoredPluginStateAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.impl.DefaultPluginEventManager;
import com.atlassian.plugin.hostcontainer.HostContainer;
import com.atlassian.plugin.loaders.PluginLoader;
import com.atlassian.plugin.manager.DefaultPluginManager;
import com.atlassian.plugin.manager.DefaultSafeModeManager;
import com.atlassian.plugin.manager.PluginPersistentStateStore;
import com.atlassian.plugin.manager.PluginRegistryImpl;
import com.atlassian.plugin.manager.ProductPluginAccessor;
import com.atlassian.plugin.manager.SafeModeManager;
import com.atlassian.plugin.manager.store.DefaultStoredPluginStateAccessor;
import com.atlassian.plugin.metadata.ClasspathFilePluginMetadata;
import com.atlassian.plugin.metadata.DefaultPluginMetadataManager;
import com.atlassian.plugin.metadata.DefaultRequiredPluginValidator;
import com.atlassian.plugin.metadata.PluginMetadataManager;
import com.atlassian.plugin.metadata.RequiredPluginProvider;
import com.atlassian.plugin.metadata.RequiredPluginValidator;
import com.atlassian.plugin.module.ClassPrefixModuleFactory;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.module.PrefixDelegatingModuleFactory;
import com.atlassian.plugin.osgi.module.BeanPrefixModuleFactory;
import com.atlassian.plugin.parsers.DefaultSafeModeCommandLineArgumentsFactory;
import com.atlassian.plugin.parsers.SafeModeCommandLineArgumentsFactory;
import com.atlassian.plugin.spring.AvailableToPlugins;
import jakarta.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class PluginManagerConfiguration {
    @Resource(name="pluginsDelayedLoadPredicate")
    Predicate<Plugin> pluginsDelayedLoadPredicate;
    @Resource(name="pluginLoaders")
    List<PluginLoader> pluginLoaders;

    @Bean
    ConfluencePluginManager pluginManager(PluginAccessor pluginAccessor, PluginPersistentStateStore pluginStateStore, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager, EventPublisher eventPublisher, PluginInstaller pluginInstaller, SafeModeManager safeModeManager) {
        DefaultPluginManager.Builder builder = ConfluencePluginManager.newBuilder().withPluginAccessor(pluginAccessor).withPluginRegistry(this.pluginRegistry()).withStore(pluginStateStore).withModuleDescriptorFactory(moduleDescriptorFactory).withPluginLoaders(this.pluginLoaders).withPluginEventManager(pluginEventManager).withSafeModeManager(safeModeManager).withDelayLoadOf(this.pluginsDelayedLoadPredicate);
        return new ConfluencePluginManager((DefaultPluginManager.Builder<? extends DefaultPluginManager.Builder>)builder, pluginAccessor, eventPublisher, pluginInstaller);
    }

    @Bean
    PluginRegistry.ReadWrite pluginRegistry() {
        return new PluginRegistryImpl();
    }

    @Bean
    PluginPersistentStateStore pluginStateStore(BandanaManagerInternal bandanaManager, @Qualifier(value="cacheManager") CacheManager cacheManager) {
        BandanaPluginStateStore store = new BandanaPluginStateStore();
        store.setBandanaManager(bandanaManager);
        return new CachingPluginPersistentStateStore((PluginPersistentStateStore)new DeprecatedPluginStateStore(store, Collections.emptyList()), (CacheFactory)cacheManager);
    }

    @Bean
    @AvailableToPlugins
    StoredPluginStateAccessor storedPluginStateAccessor(PluginPersistentStateStore pluginStateStore) {
        return new DefaultStoredPluginStateAccessor(pluginStateStore);
    }

    @Bean
    PluginInstaller pluginInstaller(PluginDataDao pluginDataDao) {
        return new DefaultPluginInstaller(pluginDataDao);
    }

    @Bean
    HibernatePluginDataDao pluginDataDao(SessionFactory sessionFactory) {
        return new HibernatePluginDataDao(sessionFactory);
    }

    @Bean
    @AvailableToPlugins
    PluginEventManager pluginEventManager(EventPublisher eventPublisher) {
        return new DefaultPluginEventManager(eventPublisher);
    }

    @Bean
    @AvailableToPlugins
    PluginMetadataManager pluginMetadataManager() {
        return new DefaultPluginMetadataManager();
    }

    @Bean
    @AvailableToPlugins
    SafeModeManager safeModeManager(ClusterManager clusterManager, PluginPersistentStateStore pluginStateStore) {
        return new DefaultSafeModeManager(this.pluginMetadataManager(), () -> ((ClusterManager)clusterManager).isClustered(), (SafeModeCommandLineArgumentsFactory)new DefaultSafeModeCommandLineArgumentsFactory(), pluginStateStore);
    }

    @Bean
    @AvailableToPlugins
    PluginController pluginController(ConfluencePluginManager pluginManager, EventPublisher eventPublisher, PluginDataDao pluginDataDao) {
        return new EventDispatchingPluginController(eventPublisher, (PluginController)pluginManager, pluginDataDao);
    }

    @Bean
    @AvailableToPlugins
    PluginAccessor pluginAccessor(PluginPersistentStateStore pluginStateStore, ModuleDescriptorFactory moduleDescriptorFactory, PluginEventManager pluginEventManager) {
        return new ProductPluginAccessor((PluginRegistry.ReadOnly)this.pluginRegistry(), pluginStateStore, moduleDescriptorFactory, pluginEventManager);
    }

    @Bean
    HostContainer hostContainer() {
        return new ConfluenceHostContainer();
    }

    @Bean
    @AvailableToPlugins
    ModuleFactory moduleFactory() {
        return new PrefixDelegatingModuleFactory(Set.of(new ClassPrefixModuleFactory(this.hostContainer()), new BeanPrefixModuleFactory()));
    }

    @Bean
    AutodetectModuleFactoryHolder autodetectModuleFactoryHolder() {
        return new AutodetectModuleFactoryHolder((ModuleFactory)new PrefixDelegatingModuleFactory(Set.of(new AutodetectClassPrefixModuleFactory(this.hostContainer()), new BeanPrefixModuleFactory())));
    }

    @Bean
    CachedIntrospectionResultsFlusher cachedIntrospectionResultsFlusher(EventListenerRegistrar eventListenerRegistrar) {
        return new CachedIntrospectionResultsFlusher(eventListenerRegistrar);
    }

    @Bean
    PluginFrameworkStartedHealthCheckListener pluginFrameworkStartedHealthCheckListener(HealthCheckRunner healthCheckRunner, EventListenerRegistrar eventListenerRegistrar) {
        return new PluginFrameworkStartedHealthCheckListener(healthCheckRunner, eventListenerRegistrar);
    }

    @Bean
    @AvailableToPlugins(value=RequiredPluginProvider.class)
    ClasspathFilePluginMetadata classpathFilePluginMetadata() {
        return new ClasspathFilePluginMetadata();
    }

    @Bean
    @AvailableToPlugins(value=RequiredPluginValidator.class)
    RequiredPluginValidator requiredPluginValidator(PluginAccessor pluginAccessor) {
        return new DefaultRequiredPluginValidator(pluginAccessor, (RequiredPluginProvider)this.classpathFilePluginMetadata());
    }
}

