/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.plugin.descriptor.search;

import com.atlassian.confluence.plugin.module.DefaultPluginModuleFactory;
import com.atlassian.confluence.plugin.module.PluginModuleFactory;
import com.atlassian.confluence.plugin.module.PluginModuleHolder;
import com.atlassian.confluence.search.SearchPlatform;
import com.atlassian.confluence.search.SearchPlatformConfig;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.spring.container.ContainerManager;
import java.util.Collection;
import java.util.HashSet;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class AbstractLuceneMapperModuleDescriptor<T>
extends AbstractModuleDescriptor<T> {
    private Collection<String> handledKeys = new HashSet<String>(1);
    private PluginModuleHolder<T> module;

    protected AbstractLuceneMapperModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory);
    }

    public void init(@NonNull Plugin plugin, @NonNull Element element) throws PluginParseException {
        super.init(plugin, element);
        if (element.attributeValue("handles") != null) {
            this.handledKeys.add(element.attributeValue("handles"));
        }
        for (Element handlesElement : element.elements("handles")) {
            this.handledKeys.add(handlesElement.getText().trim());
        }
        this.module = PluginModuleHolder.getInstance(this.getModuleFactory());
    }

    public boolean handles(String key) {
        return this.handledKeys.contains(key);
    }

    public Collection<String> getHandledKeys() {
        return new HashSet<String>(this.handledKeys);
    }

    public T getModule() {
        return this.module.getModule();
    }

    public boolean isEnabled() {
        SearchPlatformConfig searchPlatformConfig = (SearchPlatformConfig)ContainerManager.getComponent((String)"searchPlatformConfig");
        if (searchPlatformConfig.searchPlatform() == SearchPlatform.OPENSEARCH) {
            return false;
        }
        return super.isEnabled();
    }

    public void enabled() {
        super.enabled();
        this.module.enabled(this.getModuleClass());
    }

    public void disabled() {
        this.module.disabled();
        super.disabled();
    }

    protected PluginModuleFactory<T> getModuleFactory() {
        return new DefaultPluginModuleFactory(this);
    }
}

