/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.plugin.persistence;

import com.atlassian.confluence.impl.plugin.persistence.PluginDataDao;
import com.atlassian.confluence.plugin.persistence.PluginData;
import com.atlassian.confluence.plugin.persistence.PluginDataWithoutBinary;
import jakarta.persistence.PersistenceException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class HibernatePluginDataDao
implements PluginDataDao {
    private final SessionFactory sessionFactory;

    public HibernatePluginDataDao(SessionFactory sessionFactory) {
        this.sessionFactory = Objects.requireNonNull(sessionFactory);
    }

    @Override
    @Transactional(readOnly=true)
    public PluginData getPluginData(String key) throws ObjectRetrievalFailureException {
        List<PluginData> results = this.findPluginData(key);
        if (results.isEmpty()) {
            throw new ObjectRetrievalFailureException(PluginData.class, (Object)key);
        }
        return results.getFirst();
    }

    @Override
    @Transactional(readOnly=true)
    public PluginDataWithoutBinary getPluginDataWithoutBinary(String key) {
        List<PluginDataWithoutBinary> results = this.findPluginDataWithoutBinary(key);
        if (results.isEmpty()) {
            throw new ObjectRetrievalFailureException(PluginDataWithoutBinary.class, (Object)key);
        }
        return results.getFirst();
    }

    private List<PluginData> findPluginData(String key) {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.pd_findPluginDataByKey", PluginData.class).setParameter("key", (Object)key).list();
    }

    @Override
    @Transactional(readOnly=true)
    public Iterable<PluginDataWithoutBinary> getAllPluginDataWithoutBinary() {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.pd_getAllPluginDataWithoutBinary", PluginDataWithoutBinary.class).list();
    }

    private List<PluginDataWithoutBinary> findPluginDataWithoutBinary(String key) {
        return this.sessionFactory.getCurrentSession().createNamedQuery("confluence.pd_findPluginDataByKeyWithoutBinary", PluginDataWithoutBinary.class).setParameter("key", (Object)key).list();
    }

    @Override
    public void saveOrUpdate(PluginData pluginData) {
        Session session = this.sessionFactory.getCurrentSession();
        try {
            PluginData oldPluginData = (PluginData)session.get(PluginData.class, (Serializable)Long.valueOf(pluginData.getId()));
            if (oldPluginData != null) {
                session.evict((Object)oldPluginData);
            }
        }
        catch (PersistenceException e) {
            throw new RuntimeException("There was a problem evicting or flushing a PluginData object", e);
        }
        pluginData.setLastModificationDate(new Date());
        session.saveOrUpdate((Object)pluginData);
        try {
            String key = pluginData.getKey();
            session.flush();
            session.evict((Object)pluginData);
            session.evict((Object)this.getPluginDataWithoutBinary(key));
        }
        catch (HibernateException e) {
            throw new RuntimeException("There was a problem evicting or flushing a PluginData object", e);
        }
    }

    @Override
    public void remove(String key) throws ObjectRetrievalFailureException {
        this.sessionFactory.getCurrentSession().delete((Object)this.getPluginData(key));
    }

    @Override
    @Transactional(readOnly=true)
    public boolean pluginDataExists(String key) {
        return !this.findPluginDataWithoutBinary(key).isEmpty();
    }
}

