/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.plugin.settings;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PLUGIN_SETTING")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Proxy(lazy=false)
@IdClass(value=CompositeId.class)
public final class PluginSetting {
    public static final int NAMESPACE_MAX_LENGTH = 255;
    public static final int KEY_MAX_LENGTH = 100;
    public static final int SERIALIZED_VALUE_MAX_LENGTH = 99000;
    @Id
    @Column(name="NAMESPACE", length=255, nullable=false)
    private String col1_namespace;
    @Id
    @Column(name="SETTING_KEY", length=100, nullable=false)
    private String col2_key;
    @Column(name="SETTING_VALUE", length=99000, nullable=false)
    @Type(type="com.atlassian.confluence.core.persistence.hibernate.CustomClobType")
    private String value;

    public PluginSetting() {
    }

    public PluginSetting(String namespace, String key, String value) {
        this.col1_namespace = namespace;
        this.col2_key = key;
        this.value = value;
    }

    public String getNamespace() {
        return this.col1_namespace;
    }

    public void setNamespace(String namespace) {
        this.col1_namespace = namespace;
    }

    public String getKey() {
        return this.col2_key;
    }

    public void setKey(String key) {
        this.col2_key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginSetting that = (PluginSetting)o;
        return Objects.equals(this.col1_namespace, that.col1_namespace) && Objects.equals(this.col2_key, that.col2_key) && Objects.equals(this.value, that.value);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("namespace", (Object)this.col1_namespace).append("key", (Object)this.col2_key).append("value", (Object)this.value).toString();
    }

    public int hashCode() {
        return Objects.hash(this.col1_namespace, this.col2_key, this.value);
    }

    public static class CompositeId
    implements Serializable {
        private String col1_namespace;
        private String col2_key;

        public CompositeId() {
        }

        public CompositeId(String namespace, String key) {
            this.col1_namespace = namespace;
            this.col2_key = key;
        }

        public String getNamespace() {
            return this.col1_namespace;
        }

        public void setNamespace(String namespace) {
            this.col1_namespace = namespace;
        }

        public String getKey() {
            return this.col2_key;
        }

        public void setKey(String key) {
            this.col2_key = key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeId that = (CompositeId)o;
            return Objects.equals(this.col1_namespace, that.col1_namespace) && Objects.equals(this.col2_key, that.col2_key);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("namespace", (Object)this.col1_namespace).append("key", (Object)this.col2_key).toString();
        }

        public int hashCode() {
            return Objects.hash(this.col1_namespace, this.col2_key);
        }
    }
}

