/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.schedule;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
@EnableScheduling
public class SpringTaskSchedulerConfig
implements SchedulingConfigurer {
    @Value(value="#{systemProperties['confluence.scheduler-pool-size'] ?: 10}")
    private int poolSize;
    @Value(value="#{systemProperties['confluence.scheduler-shutdown-wait-seconds'] ?: 10}")
    private int awaitTerminationSeconds;
    @Value(value="#{systemProperties['confluence.scheduler-pool-name'] ?: 'ConfluenceSpringScheduler'}")
    private String threadNamePrefix;

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setTaskScheduler((TaskScheduler)this.taskScheduler());
    }

    @Bean
    ThreadPoolTaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler bean = new ThreadPoolTaskScheduler();
        bean.setPoolSize(this.poolSize);
        bean.setThreadNamePrefix(this.threadNamePrefix);
        bean.setWaitForTasksToCompleteOnShutdown(false);
        bean.setAwaitTerminationSeconds(this.awaitTerminationSeconds);
        return bean;
    }
}

