/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.schedule.caesium;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import com.atlassian.scheduler.caesium.spi.CaesiumSchedulerConfiguration;
import java.util.TimeZone;
import java.util.function.Supplier;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SchedulerConfiguration
implements CaesiumSchedulerConfiguration {
    private static final int REFRESH_INTERVAL_IN_MINUTES = 5;
    private final int WORKER_THREAD_COUNT = Integer.getInteger("confluence.scheduler.workerThreadCount", 4);
    private final ClusterManager clusterManager;
    private final Supplier<TimeZoneManager> timeZoneManager;

    public SchedulerConfiguration(ClusterManager clusterManager, Supplier<TimeZoneManager> timeZoneManager) {
        this.clusterManager = clusterManager;
        this.timeZoneManager = timeZoneManager;
    }

    public int refreshClusteredJobsIntervalInMinutes() {
        return this.clusterManager.isClustered() ? 5 : 0;
    }

    public int workerThreadCount() {
        return this.WORKER_THREAD_COUNT;
    }

    public boolean useQuartzJobDataMapMigration() {
        return false;
    }

    public boolean useFineGrainedSchedules() {
        return true;
    }

    public @Nullable TimeZone getDefaultTimeZone() {
        return this.timeZoneManager.get().getDefaultTimeZone();
    }
}

