/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.schedule.caesium;

import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.NotExportable;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.core.status.RunDetailsImpl;
import com.atlassian.scheduler.status.RunDetails;
import com.atlassian.scheduler.status.RunOutcome;
import java.util.Date;

public class SchedulerRunDetails
extends ConfluenceEntityObject
implements NotExportable {
    private String jobId;
    private Date startTime;
    private long duration;
    private char outcome;
    private String message;

    public static SchedulerRunDetails fromRunDetails(JobId jobId, RunDetails runDetails) {
        SchedulerRunDetails ret = new SchedulerRunDetails();
        ret.jobId = jobId.toString();
        ret.startTime = runDetails.getStartTime();
        ret.duration = runDetails.getDurationInMillis();
        ret.outcome = SchedulerRunDetails.runOutcomeToChar(runDetails.getRunOutcome());
        ret.message = runDetails.getMessage();
        return ret;
    }

    public RunDetails toRunDetails() {
        RunOutcome runOutcome = SchedulerRunDetails.charToRunOutcome(this.outcome);
        return new RunDetailsImpl(this.startTime, runOutcome, this.duration, this.message);
    }

    public static char runOutcomeToChar(RunOutcome runOutcome) {
        return switch (runOutcome) {
            default -> throw new MatchException(null, null);
            case RunOutcome.SUCCESS -> 'S';
            case RunOutcome.UNAVAILABLE -> 'U';
            case RunOutcome.ABORTED -> 'A';
            case RunOutcome.FAILED -> 'F';
        };
    }

    public static RunOutcome charToRunOutcome(char outcome) {
        return switch (outcome) {
            case 'S' -> RunOutcome.SUCCESS;
            case 'U' -> RunOutcome.UNAVAILABLE;
            case 'A' -> RunOutcome.ABORTED;
            case 'F' -> RunOutcome.FAILED;
            default -> throw new IllegalArgumentException("Cannot convert " + outcome + " to " + String.valueOf(RunOutcome.class));
        };
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public char getOutcome() {
        return this.outcome;
    }

    public void setOutcome(char outcome) {
        this.outcome = outcome;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}

