/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.schedule.caesium;

import com.atlassian.confluence.core.persistence.hibernate.ConfluenceHibernateObjectDao;
import com.atlassian.confluence.impl.schedule.caesium.SchedulerRunDetails;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.core.spi.RunDetailsDao;
import com.atlassian.scheduler.status.RunDetails;
import com.atlassian.scheduler.status.RunOutcome;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class SchedulerRunDetailsDao
extends ConfluenceHibernateObjectDao<SchedulerRunDetails>
implements RunDetailsDao {
    private static final Logger log = LoggerFactory.getLogger(SchedulerRunDetailsDao.class);

    @Override
    public Class<SchedulerRunDetails> getPersistentClass() {
        return SchedulerRunDetails.class;
    }

    public RunDetails getLastRunForJob(JobId jobId) {
        SchedulerRunDetails record = (SchedulerRunDetails)this.hibernate().execute(session -> {
            Query query = session.createQuery("FROM SchedulerRunDetails t WHERE t.jobId = :jobId ORDER BY t.startTime DESC");
            query.setParameter("jobId", (Object)jobId.toString());
            query.setMaxResults(1);
            return query.uniqueResult();
        });
        return record == null ? null : record.toRunDetails();
    }

    public RunDetails getLastSuccessfulRunForJob(JobId jobId) {
        SchedulerRunDetails record = (SchedulerRunDetails)this.hibernate().execute(session -> {
            Query query = session.createQuery("FROM SchedulerRunDetails t WHERE t.jobId = :jobId AND t.outcome = :outcome ORDER BY t.startTime DESC");
            query.setParameter("jobId", (Object)jobId.toString());
            query.setParameter("outcome", (Object)Character.valueOf(SchedulerRunDetails.runOutcomeToChar(RunOutcome.SUCCESS)));
            query.setMaxResults(1);
            return query.uniqueResult();
        });
        return record == null ? null : record.toRunDetails();
    }

    public Map<JobId, RunDetails> getLastRunForJobs(List<JobId> jobIds) {
        HashMap<JobId, RunDetails> runDetailsByJobId = new HashMap<JobId, RunDetails>();
        int batchSize = 1000;
        try {
            for (int i = 0; i < jobIds.size(); i += 1000) {
                List<JobId> batch = jobIds.subList(i, Math.min(jobIds.size(), i + 1000));
                Query query = this.getSessionFactory().getCurrentSession().createQuery("FROM SchedulerRunDetails t WHERE t.jobId IN (:jobIds) ORDER BY t.startTime DESC", SchedulerRunDetails.class);
                query.setParameterList("jobIds", (Collection)batch.stream().map(JobId::toString).collect(Collectors.toList()));
                List records = query.list();
                for (SchedulerRunDetails schedulerRunDetails : records) {
                    JobId jobId = JobId.of((String)schedulerRunDetails.getJobId());
                    runDetailsByJobId.putIfAbsent(jobId, schedulerRunDetails.toRunDetails());
                }
            }
        }
        catch (Exception e) {
            log.error("An error occurred while getting the last run for jobs", (Throwable)e);
            throw e;
        }
        return runDetailsByJobId;
    }

    public void addRunDetails(JobId jobId, RunDetails runDetails) {
        SchedulerRunDetails record = SchedulerRunDetails.fromRunDetails(jobId, runDetails);
        this.save(record);
    }
}

